package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListHandshakesForAccountResponse(handshakes: scala.Option[Iterable[Handshake]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse = {
    import ListHandshakesForAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse.builder().optionallyWith(handshakes.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.handshakes).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListHandshakesForAccountResponse.ReadOnly = ListHandshakesForAccountResponse.wrap(buildAwsValue())
}
object ListHandshakesForAccountResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListHandshakesForAccountResponse = ListHandshakesForAccountResponse(handshakesValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def handshakesValue: scala.Option[List[Handshake.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def handshakes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Handshake.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("handshakes", handshakesValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse) extends ListHandshakesForAccountResponse.ReadOnly {
    override def handshakesValue: scala.Option[List[Handshake.ReadOnly]] = scala.Option(impl.handshakes()).map(value => value.asScala.map { item => 
      Handshake.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse): ReadOnly = new Wrapper(impl)
}