package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListDelegatedServicesForAccountResponse(delegatedServices: scala.Option[Iterable[DelegatedService]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse = {
    import ListDelegatedServicesForAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse.builder().optionallyWith(delegatedServices.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.delegatedServices).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListDelegatedServicesForAccountResponse.ReadOnly = ListDelegatedServicesForAccountResponse.wrap(buildAwsValue())
}
object ListDelegatedServicesForAccountResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListDelegatedServicesForAccountResponse = ListDelegatedServicesForAccountResponse(delegatedServicesValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def delegatedServicesValue: scala.Option[List[DelegatedService.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def delegatedServices: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DelegatedService.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("delegatedServices", delegatedServicesValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse) extends ListDelegatedServicesForAccountResponse.ReadOnly {
    override def delegatedServicesValue: scala.Option[List[DelegatedService.ReadOnly]] = scala.Option(impl.delegatedServices()).map(value => value.asScala.map { item => 
      DelegatedService.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse): ReadOnly = new Wrapper(impl)
}