package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListDelegatedAdministratorsRequest(servicePrincipal: scala.Option[primitives.ServicePrincipal] = None, nextToken: scala.Option[primitives.NextToken] = None, maxResults: scala.Option[primitives.MaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest = {
    import ListDelegatedAdministratorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest.builder().optionallyWith(servicePrincipal.map(value => value: java.lang.String))(_.servicePrincipal).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListDelegatedAdministratorsRequest.ReadOnly = ListDelegatedAdministratorsRequest.wrap(buildAwsValue())
}
object ListDelegatedAdministratorsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListDelegatedAdministratorsRequest = ListDelegatedAdministratorsRequest(servicePrincipalValue.map(value => value), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def servicePrincipalValue: scala.Option[primitives.ServicePrincipal]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def servicePrincipal: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ServicePrincipal] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("servicePrincipal", servicePrincipalValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest) extends ListDelegatedAdministratorsRequest.ReadOnly {
    override def servicePrincipalValue: scala.Option[primitives.ServicePrincipal] = scala.Option(impl.servicePrincipal()).map(value => value: primitives.ServicePrincipal)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest): ReadOnly = new Wrapper(impl)
}