package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListChildrenResponse(children: scala.Option[Iterable[Child]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListChildrenResponse = {
    import ListChildrenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListChildrenResponse.builder().optionallyWith(children.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.children).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListChildrenResponse.ReadOnly = ListChildrenResponse.wrap(buildAwsValue())
}
object ListChildrenResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListChildrenResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListChildrenResponse = ListChildrenResponse(childrenValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def childrenValue: scala.Option[List[Child.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def children: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Child.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("children", childrenValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListChildrenResponse) extends ListChildrenResponse.ReadOnly {
    override def childrenValue: scala.Option[List[Child.ReadOnly]] = scala.Option(impl.children()).map(value => value.asScala.map { item => 
      Child.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListChildrenResponse): ReadOnly = new Wrapper(impl)
}