package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class HandshakeFilter(actionType: scala.Option[ActionType] = None, parentHandshakeId: scala.Option[primitives.HandshakeId] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.HandshakeFilter = {
    import HandshakeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.HandshakeFilter.builder().optionallyWith(actionType.map(value => value.unwrap))(_.actionType).optionallyWith(parentHandshakeId.map(value => value: java.lang.String))(_.parentHandshakeId).build()
  }
  def asReadOnly: HandshakeFilter.ReadOnly = HandshakeFilter.wrap(buildAwsValue())
}
object HandshakeFilter {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.HandshakeFilter] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: HandshakeFilter = HandshakeFilter(actionTypeValue.map(value => value), parentHandshakeIdValue.map(value => value))
    def actionTypeValue: scala.Option[ActionType]
    def parentHandshakeIdValue: scala.Option[primitives.HandshakeId]
    def actionType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ActionType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("actionType", actionTypeValue)
    def parentHandshakeId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.HandshakeId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parentHandshakeId", parentHandshakeIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.HandshakeFilter) extends HandshakeFilter.ReadOnly {
    override def actionTypeValue: scala.Option[ActionType] = scala.Option(impl.actionType()).map(value => ActionType.wrap(value))
    override def parentHandshakeIdValue: scala.Option[primitives.HandshakeId] = scala.Option(impl.parentHandshakeId()).map(value => value: primitives.HandshakeId)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.HandshakeFilter): ReadOnly = new Wrapper(impl)
}