package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Handshake(id: scala.Option[primitives.HandshakeId] = None, arn: scala.Option[primitives.HandshakeArn] = None, parties: scala.Option[Iterable[HandshakeParty]] = None, state: scala.Option[HandshakeState] = None, requestedTimestamp: scala.Option[primitives.Timestamp] = None, expirationTimestamp: scala.Option[primitives.Timestamp] = None, action: scala.Option[ActionType] = None, resources: scala.Option[Iterable[HandshakeResource]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.Handshake = {
    import Handshake.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Handshake.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(parties.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.parties).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(requestedTimestamp.map(value => value: java.time.Instant))(_.requestedTimestamp).optionallyWith(expirationTimestamp.map(value => value: java.time.Instant))(_.expirationTimestamp).optionallyWith(action.map(value => value.unwrap))(_.action).optionallyWith(resources.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.resources).build()
  }
  def asReadOnly: Handshake.ReadOnly = Handshake.wrap(buildAwsValue())
}
object Handshake {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.Handshake] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Handshake = Handshake(idValue.map(value => value), arnValue.map(value => value), partiesValue.map(value => value.map { item => 
      item.editable
    }), stateValue.map(value => value), requestedTimestampValue.map(value => value), expirationTimestampValue.map(value => value), actionValue.map(value => value), resourcesValue.map(value => value.map { item => 
      item.editable
    }))
    def idValue: scala.Option[primitives.HandshakeId]
    def arnValue: scala.Option[primitives.HandshakeArn]
    def partiesValue: scala.Option[List[HandshakeParty.ReadOnly]]
    def stateValue: scala.Option[HandshakeState]
    def requestedTimestampValue: scala.Option[primitives.Timestamp]
    def expirationTimestampValue: scala.Option[primitives.Timestamp]
    def actionValue: scala.Option[ActionType]
    def resourcesValue: scala.Option[List[HandshakeResource.ReadOnly]]
    def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.HandshakeId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.HandshakeArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def parties: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[HandshakeParty.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parties", partiesValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HandshakeState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def requestedTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("requestedTimestamp", requestedTimestampValue)
    def expirationTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expirationTimestamp", expirationTimestampValue)
    def action: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ActionType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("action", actionValue)
    def resources: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[HandshakeResource.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resources", resourcesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.Handshake) extends Handshake.ReadOnly {
    override def idValue: scala.Option[primitives.HandshakeId] = scala.Option(impl.id()).map(value => value: primitives.HandshakeId)
    override def arnValue: scala.Option[primitives.HandshakeArn] = scala.Option(impl.arn()).map(value => value: primitives.HandshakeArn)
    override def partiesValue: scala.Option[List[HandshakeParty.ReadOnly]] = scala.Option(impl.parties()).map(value => value.asScala.map { item => 
      HandshakeParty.wrap(item)
    }.toList)
    override def stateValue: scala.Option[HandshakeState] = scala.Option(impl.state()).map(value => HandshakeState.wrap(value))
    override def requestedTimestampValue: scala.Option[primitives.Timestamp] = scala.Option(impl.requestedTimestamp()).map(value => value: primitives.Timestamp)
    override def expirationTimestampValue: scala.Option[primitives.Timestamp] = scala.Option(impl.expirationTimestamp()).map(value => value: primitives.Timestamp)
    override def actionValue: scala.Option[ActionType] = scala.Option(impl.action()).map(value => ActionType.wrap(value))
    override def resourcesValue: scala.Option[List[HandshakeResource.ReadOnly]] = scala.Option(impl.resources()).map(value => value.asScala.map { item => 
      HandshakeResource.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.Handshake): ReadOnly = new Wrapper(impl)
}