package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait EffectivePolicyType { def unwrap: software.amazon.awssdk.services.organizations.model.EffectivePolicyType }
object EffectivePolicyType {
  def wrap(value: software.amazon.awssdk.services.organizations.model.EffectivePolicyType): EffectivePolicyType = value match {
    case software.amazon.awssdk.services.organizations.model.EffectivePolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.EffectivePolicyType.TAG_POLICY =>
      val r = TAG_POLICY
      r
    case software.amazon.awssdk.services.organizations.model.EffectivePolicyType.BACKUP_POLICY =>
      val r = BACKUP_POLICY
      r
    case software.amazon.awssdk.services.organizations.model.EffectivePolicyType.AISERVICES_OPT_OUT_POLICY =>
      val r = AISERVICES_OPT_OUT_POLICY
      r
  }
  case object unknownToSdkVersion extends EffectivePolicyType { override def unwrap: software.amazon.awssdk.services.organizations.model.EffectivePolicyType = software.amazon.awssdk.services.organizations.model.EffectivePolicyType.UNKNOWN_TO_SDK_VERSION }
  case object TAG_POLICY extends EffectivePolicyType { override def unwrap: software.amazon.awssdk.services.organizations.model.EffectivePolicyType = software.amazon.awssdk.services.organizations.model.EffectivePolicyType.TAG_POLICY }
  case object BACKUP_POLICY extends EffectivePolicyType { override def unwrap: software.amazon.awssdk.services.organizations.model.EffectivePolicyType = software.amazon.awssdk.services.organizations.model.EffectivePolicyType.BACKUP_POLICY }
  case object AISERVICES_OPT_OUT_POLICY extends EffectivePolicyType { override def unwrap: software.amazon.awssdk.services.organizations.model.EffectivePolicyType = software.amazon.awssdk.services.organizations.model.EffectivePolicyType.AISERVICES_OPT_OUT_POLICY }
}