package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeOrganizationResponse(organization: scala.Option[Organization] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse = {
    import DescribeOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse.builder().optionallyWith(organization.map(value => value.buildAwsValue()))(_.organization).build()
  }
  def asReadOnly: DescribeOrganizationResponse.ReadOnly = DescribeOrganizationResponse.wrap(buildAwsValue())
}
object DescribeOrganizationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeOrganizationResponse = DescribeOrganizationResponse(organizationValue.map(value => value.editable))
    def organizationValue: scala.Option[Organization.ReadOnly]
    def organization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Organization.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("organization", organizationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse) extends DescribeOrganizationResponse.ReadOnly { override def organizationValue: scala.Option[Organization.ReadOnly] = scala.Option(impl.organization()).map(value => Organization.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse): ReadOnly = new Wrapper(impl)
}