package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeHandshakeResponse(handshake: scala.Option[Handshake] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse = {
    import DescribeHandshakeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse.builder().optionallyWith(handshake.map(value => value.buildAwsValue()))(_.handshake).build()
  }
  def asReadOnly: DescribeHandshakeResponse.ReadOnly = DescribeHandshakeResponse.wrap(buildAwsValue())
}
object DescribeHandshakeResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeHandshakeResponse = DescribeHandshakeResponse(handshakeValue.map(value => value.editable))
    def handshakeValue: scala.Option[Handshake.ReadOnly]
    def handshake: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Handshake.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("handshake", handshakeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse) extends DescribeHandshakeResponse.ReadOnly { override def handshakeValue: scala.Option[Handshake.ReadOnly] = scala.Option(impl.handshake()).map(value => Handshake.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse): ReadOnly = new Wrapper(impl)
}