package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeAccountResponse(account: scala.Option[Account] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribeAccountResponse = {
    import DescribeAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeAccountResponse.builder().optionallyWith(account.map(value => value.buildAwsValue()))(_.account).build()
  }
  def asReadOnly: DescribeAccountResponse.ReadOnly = DescribeAccountResponse.wrap(buildAwsValue())
}
object DescribeAccountResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribeAccountResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeAccountResponse = DescribeAccountResponse(accountValue.map(value => value.editable))
    def accountValue: scala.Option[Account.ReadOnly]
    def account: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Account.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("account", accountValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribeAccountResponse) extends DescribeAccountResponse.ReadOnly { override def accountValue: scala.Option[Account.ReadOnly] = scala.Option(impl.account()).map(value => Account.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribeAccountResponse): ReadOnly = new Wrapper(impl)
}