package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreatePolicyRequest(content: primitives.PolicyContent, description: primitives.PolicyDescription, name: primitives.PolicyName, `type`: PolicyType, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.CreatePolicyRequest = {
    import CreatePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreatePolicyRequest.builder().content(content: java.lang.String).description(description: java.lang.String).name(name: java.lang.String).`type`(`type`.unwrap).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreatePolicyRequest.ReadOnly = CreatePolicyRequest.wrap(buildAwsValue())
}
object CreatePolicyRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.CreatePolicyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreatePolicyRequest = CreatePolicyRequest(contentValue, descriptionValue, nameValue, typeValue, tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def contentValue: primitives.PolicyContent
    def descriptionValue: primitives.PolicyDescription
    def nameValue: primitives.PolicyName
    def typeValue: PolicyType
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def content: ZIO[Any, Nothing, primitives.PolicyContent] = ZIO.succeed(contentValue)
    def description: ZIO[Any, Nothing, primitives.PolicyDescription] = ZIO.succeed(descriptionValue)
    def name: ZIO[Any, Nothing, primitives.PolicyName] = ZIO.succeed(nameValue)
    def `type`: ZIO[Any, Nothing, PolicyType] = ZIO.succeed(typeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.CreatePolicyRequest) extends CreatePolicyRequest.ReadOnly {
    override def contentValue: primitives.PolicyContent = impl.content(): primitives.PolicyContent
    override def descriptionValue: primitives.PolicyDescription = impl.description(): primitives.PolicyDescription
    override def nameValue: primitives.PolicyName = impl.name(): primitives.PolicyName
    override def typeValue: PolicyType = PolicyType.wrap(impl.`type`())
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.CreatePolicyRequest): ReadOnly = new Wrapper(impl)
}