package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateOrganizationalUnitRequest(parentId: primitives.ParentId, name: primitives.OrganizationalUnitName, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest = {
    import CreateOrganizationalUnitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest.builder().parentId(parentId: java.lang.String).name(name: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateOrganizationalUnitRequest.ReadOnly = CreateOrganizationalUnitRequest.wrap(buildAwsValue())
}
object CreateOrganizationalUnitRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateOrganizationalUnitRequest = CreateOrganizationalUnitRequest(parentIdValue, nameValue, tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def parentIdValue: primitives.ParentId
    def nameValue: primitives.OrganizationalUnitName
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def parentId: ZIO[Any, Nothing, primitives.ParentId] = ZIO.succeed(parentIdValue)
    def name: ZIO[Any, Nothing, primitives.OrganizationalUnitName] = ZIO.succeed(nameValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest) extends CreateOrganizationalUnitRequest.ReadOnly {
    override def parentIdValue: primitives.ParentId = impl.parentId(): primitives.ParentId
    override def nameValue: primitives.OrganizationalUnitName = impl.name(): primitives.OrganizationalUnitName
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest): ReadOnly = new Wrapper(impl)
}