package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateAccountStatus(id: scala.Option[primitives.CreateAccountRequestId] = None, accountName: scala.Option[primitives.AccountName] = None, state: scala.Option[CreateAccountState] = None, requestedTimestamp: scala.Option[primitives.Timestamp] = None, completedTimestamp: scala.Option[primitives.Timestamp] = None, accountId: scala.Option[primitives.AccountId] = None, govCloudAccountId: scala.Option[primitives.AccountId] = None, failureReason: scala.Option[CreateAccountFailureReason] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.CreateAccountStatus = {
    import CreateAccountStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateAccountStatus.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(accountName.map(value => value: java.lang.String))(_.accountName).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(requestedTimestamp.map(value => value: java.time.Instant))(_.requestedTimestamp).optionallyWith(completedTimestamp.map(value => value: java.time.Instant))(_.completedTimestamp).optionallyWith(accountId.map(value => value: java.lang.String))(_.accountId).optionallyWith(govCloudAccountId.map(value => value: java.lang.String))(_.govCloudAccountId).optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason).build()
  }
  def asReadOnly: CreateAccountStatus.ReadOnly = CreateAccountStatus.wrap(buildAwsValue())
}
object CreateAccountStatus {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.CreateAccountStatus] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateAccountStatus = CreateAccountStatus(idValue.map(value => value), accountNameValue.map(value => value), stateValue.map(value => value), requestedTimestampValue.map(value => value), completedTimestampValue.map(value => value), accountIdValue.map(value => value), govCloudAccountIdValue.map(value => value), failureReasonValue.map(value => value))
    def idValue: scala.Option[primitives.CreateAccountRequestId]
    def accountNameValue: scala.Option[primitives.AccountName]
    def stateValue: scala.Option[CreateAccountState]
    def requestedTimestampValue: scala.Option[primitives.Timestamp]
    def completedTimestampValue: scala.Option[primitives.Timestamp]
    def accountIdValue: scala.Option[primitives.AccountId]
    def govCloudAccountIdValue: scala.Option[primitives.AccountId]
    def failureReasonValue: scala.Option[CreateAccountFailureReason]
    def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CreateAccountRequestId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
    def accountName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountName", accountNameValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CreateAccountState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def requestedTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("requestedTimestamp", requestedTimestampValue)
    def completedTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("completedTimestamp", completedTimestampValue)
    def accountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountId", accountIdValue)
    def govCloudAccountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("govCloudAccountId", govCloudAccountIdValue)
    def failureReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CreateAccountFailureReason] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("failureReason", failureReasonValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.CreateAccountStatus) extends CreateAccountStatus.ReadOnly {
    override def idValue: scala.Option[primitives.CreateAccountRequestId] = scala.Option(impl.id()).map(value => value: primitives.CreateAccountRequestId)
    override def accountNameValue: scala.Option[primitives.AccountName] = scala.Option(impl.accountName()).map(value => value: primitives.AccountName)
    override def stateValue: scala.Option[CreateAccountState] = scala.Option(impl.state()).map(value => CreateAccountState.wrap(value))
    override def requestedTimestampValue: scala.Option[primitives.Timestamp] = scala.Option(impl.requestedTimestamp()).map(value => value: primitives.Timestamp)
    override def completedTimestampValue: scala.Option[primitives.Timestamp] = scala.Option(impl.completedTimestamp()).map(value => value: primitives.Timestamp)
    override def accountIdValue: scala.Option[primitives.AccountId] = scala.Option(impl.accountId()).map(value => value: primitives.AccountId)
    override def govCloudAccountIdValue: scala.Option[primitives.AccountId] = scala.Option(impl.govCloudAccountId()).map(value => value: primitives.AccountId)
    override def failureReasonValue: scala.Option[CreateAccountFailureReason] = scala.Option(impl.failureReason()).map(value => CreateAccountFailureReason.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.CreateAccountStatus): ReadOnly = new Wrapper(impl)
}