package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait CreateAccountState { def unwrap: software.amazon.awssdk.services.organizations.model.CreateAccountState }
object CreateAccountState {
  def wrap(value: software.amazon.awssdk.services.organizations.model.CreateAccountState): CreateAccountState = value match {
    case software.amazon.awssdk.services.organizations.model.CreateAccountState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.CreateAccountState.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.organizations.model.CreateAccountState.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.organizations.model.CreateAccountState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends CreateAccountState { override def unwrap: software.amazon.awssdk.services.organizations.model.CreateAccountState = software.amazon.awssdk.services.organizations.model.CreateAccountState.UNKNOWN_TO_SDK_VERSION }
  case object IN_PROGRESS extends CreateAccountState { override def unwrap: software.amazon.awssdk.services.organizations.model.CreateAccountState = software.amazon.awssdk.services.organizations.model.CreateAccountState.IN_PROGRESS }
  case object SUCCEEDED extends CreateAccountState { override def unwrap: software.amazon.awssdk.services.organizations.model.CreateAccountState = software.amazon.awssdk.services.organizations.model.CreateAccountState.SUCCEEDED }
  case object FAILED extends CreateAccountState { override def unwrap: software.amazon.awssdk.services.organizations.model.CreateAccountState = software.amazon.awssdk.services.organizations.model.CreateAccountState.FAILED }
}