package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateAccountResponse(createAccountStatus: scala.Option[CreateAccountStatus] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.CreateAccountResponse = {
    import CreateAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateAccountResponse.builder().optionallyWith(createAccountStatus.map(value => value.buildAwsValue()))(_.createAccountStatus).build()
  }
  def asReadOnly: CreateAccountResponse.ReadOnly = CreateAccountResponse.wrap(buildAwsValue())
}
object CreateAccountResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.CreateAccountResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateAccountResponse = CreateAccountResponse(createAccountStatusValue.map(value => value.editable))
    def createAccountStatusValue: scala.Option[CreateAccountStatus.ReadOnly]
    def createAccountStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CreateAccountStatus.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createAccountStatus", createAccountStatusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.CreateAccountResponse) extends CreateAccountResponse.ReadOnly { override def createAccountStatusValue: scala.Option[CreateAccountStatus.ReadOnly] = scala.Option(impl.createAccountStatus()).map(value => CreateAccountStatus.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.CreateAccountResponse): ReadOnly = new Wrapper(impl)
}