package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CancelHandshakeRequest(handshakeId: primitives.HandshakeId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest = {
    import CancelHandshakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest.builder().handshakeId(handshakeId: java.lang.String).build()
  }
  def asReadOnly: CancelHandshakeRequest.ReadOnly = CancelHandshakeRequest.wrap(buildAwsValue())
}
object CancelHandshakeRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CancelHandshakeRequest = CancelHandshakeRequest(handshakeIdValue)
    def handshakeIdValue: primitives.HandshakeId
    def handshakeId: ZIO[Any, Nothing, primitives.HandshakeId] = ZIO.succeed(handshakeIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest) extends CancelHandshakeRequest.ReadOnly { override def handshakeIdValue: primitives.HandshakeId = impl.handshakeId(): primitives.HandshakeId }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest): ReadOnly = new Wrapper(impl)
}