package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait AccountStatus { def unwrap: software.amazon.awssdk.services.organizations.model.AccountStatus }
object AccountStatus {
  def wrap(value: software.amazon.awssdk.services.organizations.model.AccountStatus): AccountStatus = value match {
    case software.amazon.awssdk.services.organizations.model.AccountStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.AccountStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.organizations.model.AccountStatus.SUSPENDED =>
      val r = SUSPENDED
      r
  }
  case object unknownToSdkVersion extends AccountStatus { override def unwrap: software.amazon.awssdk.services.organizations.model.AccountStatus = software.amazon.awssdk.services.organizations.model.AccountStatus.UNKNOWN_TO_SDK_VERSION }
  case object ACTIVE extends AccountStatus { override def unwrap: software.amazon.awssdk.services.organizations.model.AccountStatus = software.amazon.awssdk.services.organizations.model.AccountStatus.ACTIVE }
  case object SUSPENDED extends AccountStatus { override def unwrap: software.amazon.awssdk.services.organizations.model.AccountStatus = software.amazon.awssdk.services.organizations.model.AccountStatus.SUSPENDED }
}