package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AcceptHandshakeRequest(handshakeId: primitives.HandshakeId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest = {
    import AcceptHandshakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest.builder().handshakeId(handshakeId: java.lang.String).build()
  }
  def asReadOnly: AcceptHandshakeRequest.ReadOnly = AcceptHandshakeRequest.wrap(buildAwsValue())
}
object AcceptHandshakeRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AcceptHandshakeRequest = AcceptHandshakeRequest(handshakeIdValue)
    def handshakeIdValue: primitives.HandshakeId
    def handshakeId: ZIO[Any, Nothing, primitives.HandshakeId] = ZIO.succeed(handshakeIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest) extends AcceptHandshakeRequest.ReadOnly { override def handshakeIdValue: primitives.HandshakeId = impl.handshakeId(): primitives.HandshakeId }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest): ReadOnly = new Wrapper(impl)
}