package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PolicyTypeSummary(`type`: scala.Option[PolicyType] = None, status: scala.Option[PolicyTypeStatus] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.PolicyTypeSummary = {
    import PolicyTypeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.PolicyTypeSummary.builder().optionallyWith(`type`.map(value => value.unwrap))(_.`type`).optionallyWith(status.map(value => value.unwrap))(_.status).build()
  }
  def asReadOnly: PolicyTypeSummary.ReadOnly = PolicyTypeSummary.wrap(buildAwsValue())
}
object PolicyTypeSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.PolicyTypeSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PolicyTypeSummary = PolicyTypeSummary(typeValue.map(value => value), statusValue.map(value => value))
    def typeValue: scala.Option[PolicyType]
    def statusValue: scala.Option[PolicyTypeStatus]
    def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PolicyType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PolicyTypeStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.PolicyTypeSummary) extends PolicyTypeSummary.ReadOnly {
    override def typeValue: scala.Option[PolicyType] = scala.Option(impl.`type`()).map(value => PolicyType.wrap(value))
    override def statusValue: scala.Option[PolicyTypeStatus] = scala.Option(impl.status()).map(value => PolicyTypeStatus.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.PolicyTypeSummary): ReadOnly = new Wrapper(impl)
}