package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait OrganizationFeatureSet { def unwrap: software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet }
object OrganizationFeatureSet {
  def wrap(value: software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet): OrganizationFeatureSet = value match {
    case software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.CONSOLIDATED_BILLING =>
      val r = CONSOLIDATED_BILLING
      r
  }
  case object unknownToSdkVersion extends OrganizationFeatureSet { override def unwrap: software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet = software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.UNKNOWN_TO_SDK_VERSION }
  case object ALL extends OrganizationFeatureSet { override def unwrap: software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet = software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.ALL }
  case object CONSOLIDATED_BILLING extends OrganizationFeatureSet { override def unwrap: software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet = software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.CONSOLIDATED_BILLING }
}