package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class MoveAccountRequest(accountId: primitives.AccountId, sourceParentId: primitives.ParentId, destinationParentId: primitives.ParentId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.MoveAccountRequest = {
    import MoveAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.MoveAccountRequest.builder().accountId(accountId: java.lang.String).sourceParentId(sourceParentId: java.lang.String).destinationParentId(destinationParentId: java.lang.String).build()
  }
  def asReadOnly: MoveAccountRequest.ReadOnly = MoveAccountRequest.wrap(buildAwsValue())
}
object MoveAccountRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.MoveAccountRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: MoveAccountRequest = MoveAccountRequest(accountIdValue, sourceParentIdValue, destinationParentIdValue)
    def accountIdValue: primitives.AccountId
    def sourceParentIdValue: primitives.ParentId
    def destinationParentIdValue: primitives.ParentId
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def sourceParentId: ZIO[Any, Nothing, primitives.ParentId] = ZIO.succeed(sourceParentIdValue)
    def destinationParentId: ZIO[Any, Nothing, primitives.ParentId] = ZIO.succeed(destinationParentIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.MoveAccountRequest) extends MoveAccountRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def sourceParentIdValue: primitives.ParentId = impl.sourceParentId(): primitives.ParentId
    override def destinationParentIdValue: primitives.ParentId = impl.destinationParentId(): primitives.ParentId
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.MoveAccountRequest): ReadOnly = new Wrapper(impl)
}