package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListParentsRequest(childId: primitives.ChildId, nextToken: scala.Option[primitives.NextToken] = None, maxResults: scala.Option[primitives.MaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListParentsRequest = {
    import ListParentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListParentsRequest.builder().childId(childId: java.lang.String).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListParentsRequest.ReadOnly = ListParentsRequest.wrap(buildAwsValue())
}
object ListParentsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListParentsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListParentsRequest = ListParentsRequest(childIdValue, nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def childIdValue: primitives.ChildId
    def nextTokenValue: scala.Option[primitives.NextToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def childId: ZIO[Any, Nothing, primitives.ChildId] = ZIO.succeed(childIdValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListParentsRequest) extends ListParentsRequest.ReadOnly {
    override def childIdValue: primitives.ChildId = impl.childId(): primitives.ChildId
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListParentsRequest): ReadOnly = new Wrapper(impl)
}