package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait AccountJoinedMethod { def unwrap: software.amazon.awssdk.services.organizations.model.AccountJoinedMethod }
object AccountJoinedMethod {
  def wrap(value: software.amazon.awssdk.services.organizations.model.AccountJoinedMethod): AccountJoinedMethod = value match {
    case software.amazon.awssdk.services.organizations.model.AccountJoinedMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.AccountJoinedMethod.INVITED =>
      val r = INVITED
      r
    case software.amazon.awssdk.services.organizations.model.AccountJoinedMethod.CREATED =>
      val r = CREATED
      r
  }
  case object unknownToSdkVersion extends AccountJoinedMethod { override def unwrap: software.amazon.awssdk.services.organizations.model.AccountJoinedMethod = software.amazon.awssdk.services.organizations.model.AccountJoinedMethod.UNKNOWN_TO_SDK_VERSION }
  case object INVITED extends AccountJoinedMethod { override def unwrap: software.amazon.awssdk.services.organizations.model.AccountJoinedMethod = software.amazon.awssdk.services.organizations.model.AccountJoinedMethod.INVITED }
  case object CREATED extends AccountJoinedMethod { override def unwrap: software.amazon.awssdk.services.organizations.model.AccountJoinedMethod = software.amazon.awssdk.services.organizations.model.AccountJoinedMethod.CREATED }
}