package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
sealed trait HandshakePartyType {
  def unwrap
      : software.amazon.awssdk.services.organizations.model.HandshakePartyType
}
object HandshakePartyType {
  def wrap(
      value: software.amazon.awssdk.services.organizations.model.HandshakePartyType
  ): io.github.vigoo.zioaws.organizations.model.HandshakePartyType =
    value match {
      case software.amazon.awssdk.services.organizations.model.HandshakePartyType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.organizations.model.HandshakePartyType.ACCOUNT =>
        val r = ACCOUNT
        r
      case software.amazon.awssdk.services.organizations.model.HandshakePartyType.ORGANIZATION =>
        val r = ORGANIZATION
        r
      case software.amazon.awssdk.services.organizations.model.HandshakePartyType.EMAIL =>
        val r = EMAIL
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.organizations.model.HandshakePartyType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakePartyType =
      software.amazon.awssdk.services.organizations.model.HandshakePartyType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT
      extends io.github.vigoo.zioaws.organizations.model.HandshakePartyType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakePartyType =
      software.amazon.awssdk.services.organizations.model.HandshakePartyType.ACCOUNT
  }
  case object ORGANIZATION
      extends io.github.vigoo.zioaws.organizations.model.HandshakePartyType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakePartyType =
      software.amazon.awssdk.services.organizations.model.HandshakePartyType.ORGANIZATION
  }
  case object EMAIL
      extends io.github.vigoo.zioaws.organizations.model.HandshakePartyType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakePartyType =
      software.amazon.awssdk.services.organizations.model.HandshakePartyType.EMAIL
  }
}
