package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.HandshakeId
import scala.jdk.CollectionConverters.*
final case class HandshakeFilter(
    actionType: Option[io.github.vigoo.zioaws.organizations.model.ActionType] =
      None,
    parentHandshakeId: Option[HandshakeId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.HandshakeFilter = {
    import HandshakeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.HandshakeFilter
      .builder()
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(parentHandshakeId.map(value => value: java.lang.String))(
        _.parentHandshakeId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.HandshakeFilter.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.HandshakeFilter
      .wrap(buildAwsValue())
}
object HandshakeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.HandshakeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.HandshakeFilter =
      io.github.vigoo.zioaws.organizations.model.HandshakeFilter(
        actionTypeValue.map(value => value),
        parentHandshakeIdValue.map(value => value)
      )
    def actionTypeValue
        : Option[io.github.vigoo.zioaws.organizations.model.ActionType]
    def parentHandshakeIdValue: Option[HandshakeId]
    def actionType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.ActionType
    ] = AwsError.unwrapOptionField("actionType", actionTypeValue)
    def parentHandshakeId: ZIO[Any, AwsError, HandshakeId] =
      AwsError.unwrapOptionField("parentHandshakeId", parentHandshakeIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.HandshakeFilter
  ) extends io.github.vigoo.zioaws.organizations.model.HandshakeFilter.ReadOnly {
    override def actionTypeValue
        : Option[io.github.vigoo.zioaws.organizations.model.ActionType] = scala
      .Option(impl.actionType())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.ActionType.wrap(value)
      )
    override def parentHandshakeIdValue: Option[HandshakeId] =
      scala.Option(impl.parentHandshakeId()).map(value => value: HandshakeId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.HandshakeFilter
  ): io.github.vigoo.zioaws.organizations.model.HandshakeFilter.ReadOnly =
    new Wrapper(impl)
}
