package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
sealed trait ActionType {
  def unwrap: software.amazon.awssdk.services.organizations.model.ActionType
}
object ActionType {
  def wrap(
      value: software.amazon.awssdk.services.organizations.model.ActionType
  ): io.github.vigoo.zioaws.organizations.model.ActionType = value match {
    case software.amazon.awssdk.services.organizations.model.ActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.ActionType.INVITE =>
      val r = INVITE
      r
    case software.amazon.awssdk.services.organizations.model.ActionType.ENABLE_ALL_FEATURES =>
      val r = ENABLE_ALL_FEATURES
      r
    case software.amazon.awssdk.services.organizations.model.ActionType.APPROVE_ALL_FEATURES =>
      val r = APPROVE_ALL_FEATURES
      r
    case software.amazon.awssdk.services.organizations.model.ActionType.ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE =>
      val r = ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.organizations.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.ActionType =
      software.amazon.awssdk.services.organizations.model.ActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object INVITE
      extends io.github.vigoo.zioaws.organizations.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.ActionType =
      software.amazon.awssdk.services.organizations.model.ActionType.INVITE
  }
  case object ENABLE_ALL_FEATURES
      extends io.github.vigoo.zioaws.organizations.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.ActionType =
      software.amazon.awssdk.services.organizations.model.ActionType.ENABLE_ALL_FEATURES
  }
  case object APPROVE_ALL_FEATURES
      extends io.github.vigoo.zioaws.organizations.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.ActionType =
      software.amazon.awssdk.services.organizations.model.ActionType.APPROVE_ALL_FEATURES
  }
  case object ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE
      extends io.github.vigoo.zioaws.organizations.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.ActionType =
      software.amazon.awssdk.services.organizations.model.ActionType.ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE
  }
}
