package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.organizations.model.DelegatedAdministrator.ReadOnly
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.organizations.model.{
  Account,
  ListRootsRequest,
  DescribeOrganizationalUnitResponse,
  PolicySummary,
  CreateAccountRequest,
  EnabledServicePrincipal,
  ListChildrenRequest,
  MoveAccountResponse,
  PolicyTargetSummary,
  CreatePolicyResponse,
  ListAwsServiceAccessForOrganizationResponse,
  RemoveAccountFromOrganizationResponse,
  ListPoliciesForTargetResponse,
  ListPoliciesRequest,
  DescribePolicyRequest,
  DescribeEffectivePolicyRequest,
  UpdatePolicyRequest,
  DeleteOrganizationalUnitRequest,
  LeaveOrganizationRequest,
  DescribeOrganizationalUnitRequest,
  ListPoliciesResponse,
  ListAccountsForParentRequest,
  DelegatedService,
  ListHandshakesForAccountResponse,
  OrganizationalUnit,
  DisableAwsServiceAccessResponse,
  CreateAccountResponse,
  CreateOrganizationRequest,
  DescribeOrganizationRequest,
  CreateAccountStatus,
  UpdateOrganizationalUnitRequest,
  ListParentsRequest,
  EnableAwsServiceAccessRequest,
  DescribePolicyResponse,
  ListAccountsResponse,
  ListParentsResponse,
  DeleteOrganizationalUnitResponse,
  ListTagsForResourceRequest,
  Tag,
  DelegatedAdministrator,
  ListHandshakesForAccountRequest,
  ListTargetsForPolicyRequest,
  DescribeAccountResponse,
  DescribeHandshakeRequest,
  ListTagsForResourceResponse,
  RegisterDelegatedAdministratorResponse,
  UntagResourceResponse,
  ListPoliciesForTargetRequest,
  EnablePolicyTypeResponse,
  DetachPolicyResponse,
  CancelHandshakeResponse,
  AttachPolicyResponse,
  DisablePolicyTypeResponse,
  ListCreateAccountStatusRequest,
  CreateGovCloudAccountResponse,
  DescribeOrganizationResponse,
  DeletePolicyResponse,
  InviteAccountToOrganizationResponse,
  ListRootsResponse,
  ListHandshakesForOrganizationRequest,
  LeaveOrganizationResponse,
  ListOrganizationalUnitsForParentRequest,
  ListOrganizationalUnitsForParentResponse,
  CreateGovCloudAccountRequest,
  InviteAccountToOrganizationRequest,
  ListCreateAccountStatusResponse,
  CancelHandshakeRequest,
  ListAccountsRequest,
  ListDelegatedServicesForAccountRequest,
  DeclineHandshakeRequest,
  AcceptHandshakeRequest,
  DetachPolicyRequest,
  UntagResourceRequest,
  ListTargetsForPolicyResponse,
  ListDelegatedAdministratorsRequest,
  EnableAllFeaturesRequest,
  ListChildrenResponse,
  DeclineHandshakeResponse,
  DescribeEffectivePolicyResponse,
  UpdatePolicyResponse,
  ListAwsServiceAccessForOrganizationRequest,
  Parent,
  UpdateOrganizationalUnitResponse,
  Child,
  DisableAwsServiceAccessRequest,
  DeregisterDelegatedAdministratorResponse,
  CreateOrganizationalUnitRequest,
  CreateOrganizationalUnitResponse,
  DescribeCreateAccountStatusResponse,
  AcceptHandshakeResponse,
  DescribeCreateAccountStatusRequest,
  RegisterDelegatedAdministratorRequest,
  ListAccountsForParentResponse,
  Root,
  DisablePolicyTypeRequest,
  Handshake,
  DescribeHandshakeResponse,
  TagResourceResponse,
  DeletePolicyRequest,
  ListHandshakesForOrganizationResponse,
  DeleteOrganizationResponse,
  DeleteOrganizationRequest,
  MoveAccountRequest,
  RemoveAccountFromOrganizationRequest,
  EnableAwsServiceAccessResponse,
  EnableAllFeaturesResponse,
  ListDelegatedServicesForAccountResponse,
  TagResourceRequest,
  CreateOrganizationResponse,
  AttachPolicyRequest,
  CreatePolicyRequest,
  DescribeAccountRequest,
  DeregisterDelegatedAdministratorRequest,
  ListDelegatedAdministratorsResponse,
  EnablePolicyTypeRequest
}
import software.amazon.awssdk.services.organizations.{
  OrganizationsAsyncClientBuilder,
  OrganizationsAsyncClient
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.stream.ZStream
import io.github.vigoo.zioaws.organizations.Organizations
import zio.test.mock.{Proxy, Mock}
package object organizations {
  import scala.jdk.CollectionConverters.*
  type Organizations = Has[Organizations.Service]
  object Organizations {
    trait Service extends AspectSupport[Service] {
      val api: OrganizationsAsyncClient
      def listParents(
          request: io.github.vigoo.zioaws.organizations.model.ListParentsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly
      ]
      def inviteAccountToOrganization(
          request: io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationResponse.ReadOnly
      ]
      def describeOrganization(): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DescribeOrganizationResponse.ReadOnly
      ]
      def describePolicy(
          request: io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DescribePolicyResponse.ReadOnly
      ]
      def createAccount(
          request: io.github.vigoo.zioaws.organizations.model.CreateAccountRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.CreateAccountResponse.ReadOnly
      ]
      def moveAccount(
          request: io.github.vigoo.zioaws.organizations.model.MoveAccountRequest
      ): IO[AwsError, Unit]
      def listAccounts(
          request: io.github.vigoo.zioaws.organizations.model.ListAccountsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
      ]
      def deleteOrganizationalUnit(
          request: io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest
      ): IO[AwsError, Unit]
      def enableAllFeatures(
          request: io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesResponse.ReadOnly
      ]
      def cancelHandshake(
          request: io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse.ReadOnly
      ]
      def listAccountsForParent(
          request: io.github.vigoo.zioaws.organizations.model.ListAccountsForParentRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
      ]
      def enablePolicyType(
          request: io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse.ReadOnly
      ]
      def disablePolicyType(
          request: io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse.ReadOnly
      ]
      def describeOrganizationalUnit(
          request: io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitResponse.ReadOnly
      ]
      def listHandshakesForOrganization(
          request: io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
      ]
      def listTargetsForPolicy(
          request: io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly
      ]
      def detachPolicy(
          request: io.github.vigoo.zioaws.organizations.model.DetachPolicyRequest
      ): IO[AwsError, Unit]
      def updatePolicy(
          request: io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.UpdatePolicyResponse.ReadOnly
      ]
      def leaveOrganization(): IO[AwsError, Unit]
      def enableAWSServiceAccess(
          request: io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest
      ): IO[AwsError, Unit]
      def describeAccount(
          request: io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse.ReadOnly
      ]
      def deleteOrganization(): IO[AwsError, Unit]
      def createOrganizationalUnit(
          request: io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse.ReadOnly
      ]
      def acceptHandshake(
          request: io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse.ReadOnly
      ]
      def listPoliciesForTarget(
          request: io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
      ]
      def listOrganizationalUnitsForParent(
          request: io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
      ]
      def updateOrganizationalUnit(
          request: io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse.ReadOnly
      ]
      def listPolicies(
          request: io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
      ]
      def describeHandshake(
          request: io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DescribeHandshakeResponse.ReadOnly
      ]
      def describeCreateAccountStatus(
          request: io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse.ReadOnly
      ]
      def listRoots(
          request: io.github.vigoo.zioaws.organizations.model.ListRootsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.Root.ReadOnly
      ]
      def listCreateAccountStatus(
          request: io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
      ]
      def untagResource(
          request: io.github.vigoo.zioaws.organizations.model.UntagResourceRequest
      ): IO[AwsError, Unit]
      def removeAccountFromOrganization(
          request: io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest
      ): IO[AwsError, Unit]
      def listAWSServiceAccessForOrganization(
          request: io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly
      ]
      def deregisterDelegatedAdministrator(
          request: io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest
      ): IO[AwsError, Unit]
      def declineHandshake(
          request: io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse.ReadOnly
      ]
      def attachPolicy(
          request: io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest
      ): IO[AwsError, Unit]
      def listTagsForResource(
          request: io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
      ]
      def listDelegatedServicesForAccount(
          request: io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly
      ]
      def registerDelegatedAdministrator(
          request: io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest
      ): IO[AwsError, Unit]
      def describeEffectivePolicy(
          request: io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse.ReadOnly
      ]
      def createPolicy(
          request: io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse.ReadOnly
      ]
      def tagResource(
          request: io.github.vigoo.zioaws.organizations.model.TagResourceRequest
      ): IO[AwsError, Unit]
      def listChildren(
          request: io.github.vigoo.zioaws.organizations.model.ListChildrenRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.Child.ReadOnly
      ]
      def deletePolicy(
          request: io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest
      ): IO[AwsError, Unit]
      def listHandshakesForAccount(
          request: io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
      ]
      def createGovCloudAccount(
          request: io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountResponse.ReadOnly
      ]
      def disableAWSServiceAccess(
          request: io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest
      ): IO[AwsError, Unit]
      def listDelegatedAdministrators(
          request: io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest
      ): ZStream[Any, AwsError, ReadOnly]
      def createOrganization(
          request: io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse.ReadOnly
      ]
    }
    object OrganizationsMock extends Mock[Organizations] {
      object ListParents
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListParentsRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly
          ]
      object InviteAccountToOrganization
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationResponse.ReadOnly
          ]
      object DescribeOrganization
          extends Effect[
            Unit,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DescribeOrganizationResponse.ReadOnly
          ]
      object DescribePolicy
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DescribePolicyResponse.ReadOnly
          ]
      object CreateAccount
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.CreateAccountRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.CreateAccountResponse.ReadOnly
          ]
      object MoveAccount
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.MoveAccountRequest,
            AwsError,
            Unit
          ]
      object ListAccounts
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListAccountsRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
          ]
      object DeleteOrganizationalUnit
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest,
            AwsError,
            Unit
          ]
      object EnableAllFeatures
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesResponse.ReadOnly
          ]
      object CancelHandshake
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse.ReadOnly
          ]
      object ListAccountsForParent
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListAccountsForParentRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
          ]
      object EnablePolicyType
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse.ReadOnly
          ]
      object DisablePolicyType
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse.ReadOnly
          ]
      object DescribeOrganizationalUnit
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitResponse.ReadOnly
          ]
      object ListHandshakesForOrganization
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
          ]
      object ListTargetsForPolicy
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly
          ]
      object DetachPolicy
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DetachPolicyRequest,
            AwsError,
            Unit
          ]
      object UpdatePolicy
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.UpdatePolicyResponse.ReadOnly
          ]
      object LeaveOrganization extends Effect[Unit, AwsError, Unit]
      object EnableAWSServiceAccess
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest,
            AwsError,
            Unit
          ]
      object DescribeAccount
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse.ReadOnly
          ]
      object DeleteOrganization extends Effect[Unit, AwsError, Unit]
      object CreateOrganizationalUnit
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse.ReadOnly
          ]
      object AcceptHandshake
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse.ReadOnly
          ]
      object ListPoliciesForTarget
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
          ]
      object ListOrganizationalUnitsForParent
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
          ]
      object UpdateOrganizationalUnit
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse.ReadOnly
          ]
      object ListPolicies
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
          ]
      object DescribeHandshake
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DescribeHandshakeResponse.ReadOnly
          ]
      object DescribeCreateAccountStatus
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse.ReadOnly
          ]
      object ListRoots
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListRootsRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.Root.ReadOnly
          ]
      object ListCreateAccountStatus
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
          ]
      object UntagResource
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.UntagResourceRequest,
            AwsError,
            Unit
          ]
      object RemoveAccountFromOrganization
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest,
            AwsError,
            Unit
          ]
      object ListAWSServiceAccessForOrganization
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly
          ]
      object DeregisterDelegatedAdministrator
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest,
            AwsError,
            Unit
          ]
      object DeclineHandshake
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse.ReadOnly
          ]
      object AttachPolicy
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest,
            AwsError,
            Unit
          ]
      object ListTagsForResource
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
          ]
      object ListDelegatedServicesForAccount
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly
          ]
      object RegisterDelegatedAdministrator
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest,
            AwsError,
            Unit
          ]
      object DescribeEffectivePolicy
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse.ReadOnly
          ]
      object CreatePolicy
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse.ReadOnly
          ]
      object TagResource
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.TagResourceRequest,
            AwsError,
            Unit
          ]
      object ListChildren
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListChildrenRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.Child.ReadOnly
          ]
      object DeletePolicy
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest,
            AwsError,
            Unit
          ]
      object ListHandshakesForAccount
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
          ]
      object CreateGovCloudAccount
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountResponse.ReadOnly
          ]
      object DisableAWSServiceAccess
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest,
            AwsError,
            Unit
          ]
      object ListDelegatedAdministrators
          extends Stream[
            io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest,
            AwsError,
            ReadOnly
          ]
      object CreateOrganization
          extends Effect[
            io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest,
            AwsError,
            io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], Organizations] = ZLayer.fromServiceM {
        proxy =>
          withRuntime.map { rts =>
            new Organizations.Service {
              val api: OrganizationsAsyncClient = null
              def withAspect[R1](
                  newAspect: AwsCallAspect[R1],
                  r: R1
              ): Organizations.Service = this
              def listParents(
                  request: io.github.vigoo.zioaws.organizations.model.ListParentsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly
              ] = rts.unsafeRun(proxy(ListParents, request))
              def inviteAccountToOrganization(
                  request: io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationResponse.ReadOnly
              ] = proxy(InviteAccountToOrganization, request)
              def describeOrganization(): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DescribeOrganizationResponse.ReadOnly
              ] = proxy(DescribeOrganization)
              def describePolicy(
                  request: io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DescribePolicyResponse.ReadOnly
              ] = proxy(DescribePolicy, request)
              def createAccount(
                  request: io.github.vigoo.zioaws.organizations.model.CreateAccountRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.CreateAccountResponse.ReadOnly
              ] = proxy(CreateAccount, request)
              def moveAccount(
                  request: io.github.vigoo.zioaws.organizations.model.MoveAccountRequest
              ): IO[AwsError, Unit] = proxy(MoveAccount, request)
              def listAccounts(
                  request: io.github.vigoo.zioaws.organizations.model.ListAccountsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
              ] = rts.unsafeRun(proxy(ListAccounts, request))
              def deleteOrganizationalUnit(
                  request: io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest
              ): IO[AwsError, Unit] = proxy(DeleteOrganizationalUnit, request)
              def enableAllFeatures(
                  request: io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesResponse.ReadOnly
              ] = proxy(EnableAllFeatures, request)
              def cancelHandshake(
                  request: io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse.ReadOnly
              ] = proxy(CancelHandshake, request)
              def listAccountsForParent(
                  request: io.github.vigoo.zioaws.organizations.model.ListAccountsForParentRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
              ] = rts.unsafeRun(proxy(ListAccountsForParent, request))
              def enablePolicyType(
                  request: io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse.ReadOnly
              ] = proxy(EnablePolicyType, request)
              def disablePolicyType(
                  request: io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse.ReadOnly
              ] = proxy(DisablePolicyType, request)
              def describeOrganizationalUnit(
                  request: io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitResponse.ReadOnly
              ] = proxy(DescribeOrganizationalUnit, request)
              def listHandshakesForOrganization(
                  request: io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
              ] = rts.unsafeRun(proxy(ListHandshakesForOrganization, request))
              def listTargetsForPolicy(
                  request: io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly
              ] = rts.unsafeRun(proxy(ListTargetsForPolicy, request))
              def detachPolicy(
                  request: io.github.vigoo.zioaws.organizations.model.DetachPolicyRequest
              ): IO[AwsError, Unit] = proxy(DetachPolicy, request)
              def updatePolicy(
                  request: io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.UpdatePolicyResponse.ReadOnly
              ] = proxy(UpdatePolicy, request)
              def leaveOrganization(): IO[AwsError, Unit] =
                proxy(LeaveOrganization)
              def enableAWSServiceAccess(
                  request: io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest
              ): IO[AwsError, Unit] = proxy(EnableAWSServiceAccess, request)
              def describeAccount(
                  request: io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse.ReadOnly
              ] = proxy(DescribeAccount, request)
              def deleteOrganization(): IO[AwsError, Unit] =
                proxy(DeleteOrganization)
              def createOrganizationalUnit(
                  request: io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse.ReadOnly
              ] = proxy(CreateOrganizationalUnit, request)
              def acceptHandshake(
                  request: io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse.ReadOnly
              ] = proxy(AcceptHandshake, request)
              def listPoliciesForTarget(
                  request: io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
              ] = rts.unsafeRun(proxy(ListPoliciesForTarget, request))
              def listOrganizationalUnitsForParent(
                  request: io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
              ] =
                rts.unsafeRun(proxy(ListOrganizationalUnitsForParent, request))
              def updateOrganizationalUnit(
                  request: io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse.ReadOnly
              ] = proxy(UpdateOrganizationalUnit, request)
              def listPolicies(
                  request: io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
              ] = rts.unsafeRun(proxy(ListPolicies, request))
              def describeHandshake(
                  request: io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DescribeHandshakeResponse.ReadOnly
              ] = proxy(DescribeHandshake, request)
              def describeCreateAccountStatus(
                  request: io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse.ReadOnly
              ] = proxy(DescribeCreateAccountStatus, request)
              def listRoots(
                  request: io.github.vigoo.zioaws.organizations.model.ListRootsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.Root.ReadOnly
              ] = rts.unsafeRun(proxy(ListRoots, request))
              def listCreateAccountStatus(
                  request: io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
              ] = rts.unsafeRun(proxy(ListCreateAccountStatus, request))
              def untagResource(
                  request: io.github.vigoo.zioaws.organizations.model.UntagResourceRequest
              ): IO[AwsError, Unit] = proxy(UntagResource, request)
              def removeAccountFromOrganization(
                  request: io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest
              ): IO[AwsError, Unit] =
                proxy(RemoveAccountFromOrganization, request)
              def listAWSServiceAccessForOrganization(
                  request: io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly
              ] = rts.unsafeRun(
                proxy(ListAWSServiceAccessForOrganization, request)
              )
              def deregisterDelegatedAdministrator(
                  request: io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest
              ): IO[AwsError, Unit] =
                proxy(DeregisterDelegatedAdministrator, request)
              def declineHandshake(
                  request: io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse.ReadOnly
              ] = proxy(DeclineHandshake, request)
              def attachPolicy(
                  request: io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest
              ): IO[AwsError, Unit] = proxy(AttachPolicy, request)
              def listTagsForResource(
                  request: io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
              ] = rts.unsafeRun(proxy(ListTagsForResource, request))
              def listDelegatedServicesForAccount(
                  request: io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly
              ] = rts.unsafeRun(proxy(ListDelegatedServicesForAccount, request))
              def registerDelegatedAdministrator(
                  request: io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest
              ): IO[AwsError, Unit] =
                proxy(RegisterDelegatedAdministrator, request)
              def describeEffectivePolicy(
                  request: io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse.ReadOnly
              ] = proxy(DescribeEffectivePolicy, request)
              def createPolicy(
                  request: io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse.ReadOnly
              ] = proxy(CreatePolicy, request)
              def tagResource(
                  request: io.github.vigoo.zioaws.organizations.model.TagResourceRequest
              ): IO[AwsError, Unit] = proxy(TagResource, request)
              def listChildren(
                  request: io.github.vigoo.zioaws.organizations.model.ListChildrenRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.Child.ReadOnly
              ] = rts.unsafeRun(proxy(ListChildren, request))
              def deletePolicy(
                  request: io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest
              ): IO[AwsError, Unit] = proxy(DeletePolicy, request)
              def listHandshakesForAccount(
                  request: io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
              ] = rts.unsafeRun(proxy(ListHandshakesForAccount, request))
              def createGovCloudAccount(
                  request: io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountResponse.ReadOnly
              ] = proxy(CreateGovCloudAccount, request)
              def disableAWSServiceAccess(
                  request: io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest
              ): IO[AwsError, Unit] = proxy(DisableAWSServiceAccess, request)
              def listDelegatedAdministrators(
                  request: io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest
              ): ZStream[Any, AwsError, ReadOnly] =
                rts.unsafeRun(proxy(ListDelegatedAdministrators, request))
              def createOrganization(
                  request: io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse.ReadOnly
              ] = proxy(CreateOrganization, request)
            }
          }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, Organizations] = customized(
    identity
  )
  def customized(
      customization: OrganizationsAsyncClientBuilder => OrganizationsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Organizations] = managed(
    customization
  ).toLayer
  def managed(
      customization: OrganizationsAsyncClientBuilder => OrganizationsAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Organizations.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = OrganizationsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[OrganizationsAsyncClient, OrganizationsAsyncClientBuilder](
        builder
      )
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[
        OrganizationsAsyncClient,
        OrganizationsAsyncClientBuilder
      ](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  )
    yield new OrganizationsImpl(
      client,
      AwsCallAspect.identity,
      ().asInstanceOf[Any]
    )
  private class OrganizationsImpl[R](
      override val api: OrganizationsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends Organizations.Service
      with AwsServiceBase[R, OrganizationsImpl] {
    override val serviceName: String = "Organizations"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): OrganizationsImpl[R1] = new OrganizationsImpl(api, newAspect, r)
    def listParents(
        request: io.github.vigoo.zioaws.organizations.model.ListParentsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListParentsRequest,
      ListParentsResponse,
      Parent
    ](
      "listParents",
      api.listParents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.parents().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.organizations.model.Parent.wrap(item))
      .provide(r)
    def inviteAccountToOrganization(
        request: io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      InviteAccountToOrganizationRequest,
      InviteAccountToOrganizationResponse
    ]("inviteAccountToOrganization", api.inviteAccountToOrganization)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationResponse.wrap
    ).provide(r)
    def describeOrganization(): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DescribeOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrganizationRequest,
      DescribeOrganizationResponse
    ]("describeOrganization", api.describeOrganization)(
      DescribeOrganizationRequest.builder().build()
    ).map(
      io.github.vigoo.zioaws.organizations.model.DescribeOrganizationResponse.wrap
    ).provide(r)
    def describePolicy(
        request: io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DescribePolicyResponse.ReadOnly
    ] = asyncRequestResponse[DescribePolicyRequest, DescribePolicyResponse](
      "describePolicy",
      api.describePolicy
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.organizations.model.DescribePolicyResponse.wrap
      )
      .provide(r)
    def createAccount(
        request: io.github.vigoo.zioaws.organizations.model.CreateAccountRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CreateAccountResponse.ReadOnly
    ] = asyncRequestResponse[CreateAccountRequest, CreateAccountResponse](
      "createAccount",
      api.createAccount
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.organizations.model.CreateAccountResponse.wrap
      )
      .provide(r)
    def moveAccount(
        request: io.github.vigoo.zioaws.organizations.model.MoveAccountRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[MoveAccountRequest, MoveAccountResponse](
        "moveAccount",
        api.moveAccount
      )(request.buildAwsValue()).unit.provide(r)
    def listAccounts(
        request: io.github.vigoo.zioaws.organizations.model.ListAccountsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAccountsRequest,
      ListAccountsResponse,
      Account
    ](
      "listAccounts",
      api.listAccounts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accounts().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.Account.wrap(item)
      )
      .provide(r)
    def deleteOrganizationalUnit(
        request: io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteOrganizationalUnitRequest,
      DeleteOrganizationalUnitResponse
    ]("deleteOrganizationalUnit", api.deleteOrganizationalUnit)(
      request.buildAwsValue()
    ).unit.provide(r)
    def enableAllFeatures(
        request: io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesResponse.ReadOnly
    ] =
      asyncRequestResponse[EnableAllFeaturesRequest, EnableAllFeaturesResponse](
        "enableAllFeatures",
        api.enableAllFeatures
      )(request.buildAwsValue())
        .map(
          io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesResponse.wrap
        )
        .provide(r)
    def cancelHandshake(
        request: io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse.ReadOnly
    ] = asyncRequestResponse[CancelHandshakeRequest, CancelHandshakeResponse](
      "cancelHandshake",
      api.cancelHandshake
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse.wrap
      )
      .provide(r)
    def listAccountsForParent(
        request: io.github.vigoo.zioaws.organizations.model.ListAccountsForParentRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAccountsForParentRequest,
      ListAccountsForParentResponse,
      Account
    ](
      "listAccountsForParent",
      api.listAccountsForParent,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accounts().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.Account.wrap(item)
      )
      .provide(r)
    def enablePolicyType(
        request: io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse.ReadOnly
    ] = asyncRequestResponse[EnablePolicyTypeRequest, EnablePolicyTypeResponse](
      "enablePolicyType",
      api.enablePolicyType
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse.wrap
      )
      .provide(r)
    def disablePolicyType(
        request: io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse.ReadOnly
    ] =
      asyncRequestResponse[DisablePolicyTypeRequest, DisablePolicyTypeResponse](
        "disablePolicyType",
        api.disablePolicyType
      )(request.buildAwsValue())
        .map(
          io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse.wrap
        )
        .provide(r)
    def describeOrganizationalUnit(
        request: io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrganizationalUnitRequest,
      DescribeOrganizationalUnitResponse
    ]("describeOrganizationalUnit", api.describeOrganizationalUnit)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitResponse.wrap
    ).provide(r)
    def listHandshakesForOrganization(
        request: io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListHandshakesForOrganizationRequest,
      ListHandshakesForOrganizationResponse,
      Handshake
    ](
      "listHandshakesForOrganization",
      api.listHandshakesForOrganization,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.handshakes().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.Handshake.wrap(item)
      )
      .provide(r)
    def listTargetsForPolicy(
        request: io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListTargetsForPolicyRequest,
      ListTargetsForPolicyResponse,
      PolicyTargetSummary
    ](
      "listTargetsForPolicy",
      api.listTargetsForPolicy,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.targets().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary
          .wrap(item)
      )
      .provide(r)
    def detachPolicy(
        request: io.github.vigoo.zioaws.organizations.model.DetachPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DetachPolicyRequest, DetachPolicyResponse](
        "detachPolicy",
        api.detachPolicy
      )(request.buildAwsValue()).unit.provide(r)
    def updatePolicy(
        request: io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.UpdatePolicyResponse.ReadOnly
    ] = asyncRequestResponse[UpdatePolicyRequest, UpdatePolicyResponse](
      "updatePolicy",
      api.updatePolicy
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.organizations.model.UpdatePolicyResponse.wrap)
      .provide(r)
    def leaveOrganization(): IO[AwsError, Unit] =
      asyncRequestResponse[LeaveOrganizationRequest, LeaveOrganizationResponse](
        "leaveOrganization",
        api.leaveOrganization
      )(LeaveOrganizationRequest.builder().build()).unit.provide(r)
    def enableAWSServiceAccess(
        request: io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      EnableAwsServiceAccessRequest,
      EnableAwsServiceAccessResponse
    ]("enableAWSServiceAccess", api.enableAWSServiceAccess)(
      request.buildAwsValue()
    ).unit.provide(r)
    def describeAccount(
        request: io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse.ReadOnly
    ] = asyncRequestResponse[DescribeAccountRequest, DescribeAccountResponse](
      "describeAccount",
      api.describeAccount
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse.wrap
      )
      .provide(r)
    def deleteOrganization(): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteOrganizationRequest,
      DeleteOrganizationResponse
    ]("deleteOrganization", api.deleteOrganization)(
      DeleteOrganizationRequest.builder().build()
    ).unit.provide(r)
    def createOrganizationalUnit(
        request: io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateOrganizationalUnitRequest,
      CreateOrganizationalUnitResponse
    ]("createOrganizationalUnit", api.createOrganizationalUnit)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse.wrap
    ).provide(r)
    def acceptHandshake(
        request: io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse.ReadOnly
    ] = asyncRequestResponse[AcceptHandshakeRequest, AcceptHandshakeResponse](
      "acceptHandshake",
      api.acceptHandshake
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse.wrap
      )
      .provide(r)
    def listPoliciesForTarget(
        request: io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListPoliciesForTargetRequest,
      ListPoliciesForTargetResponse,
      PolicySummary
    ](
      "listPoliciesForTarget",
      api.listPoliciesForTarget,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.policies().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.PolicySummary.wrap(item)
      )
      .provide(r)
    def listOrganizationalUnitsForParent(
        request: io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListOrganizationalUnitsForParentRequest,
      ListOrganizationalUnitsForParentResponse,
      OrganizationalUnit
    ](
      "listOrganizationalUnitsForParent",
      api.listOrganizationalUnitsForParent,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.organizationalUnits().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.wrap(item)
      )
      .provide(r)
    def updateOrganizationalUnit(
        request: io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateOrganizationalUnitRequest,
      UpdateOrganizationalUnitResponse
    ]("updateOrganizationalUnit", api.updateOrganizationalUnit)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse.wrap
    ).provide(r)
    def listPolicies(
        request: io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListPoliciesRequest,
      ListPoliciesResponse,
      PolicySummary
    ](
      "listPolicies",
      api.listPolicies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.policies().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.PolicySummary.wrap(item)
      )
      .provide(r)
    def describeHandshake(
        request: io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DescribeHandshakeResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeHandshakeRequest, DescribeHandshakeResponse](
        "describeHandshake",
        api.describeHandshake
      )(request.buildAwsValue())
        .map(
          io.github.vigoo.zioaws.organizations.model.DescribeHandshakeResponse.wrap
        )
        .provide(r)
    def describeCreateAccountStatus(
        request: io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCreateAccountStatusRequest,
      DescribeCreateAccountStatusResponse
    ]("describeCreateAccountStatus", api.describeCreateAccountStatus)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse.wrap
    ).provide(r)
    def listRoots(
        request: io.github.vigoo.zioaws.organizations.model.ListRootsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Root.ReadOnly
    ] = asyncSimplePaginatedRequest[ListRootsRequest, ListRootsResponse, Root](
      "listRoots",
      api.listRoots,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.roots().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.organizations.model.Root.wrap(item))
      .provide(r)
    def listCreateAccountStatus(
        request: io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListCreateAccountStatusRequest,
      ListCreateAccountStatusResponse,
      CreateAccountStatus
    ](
      "listCreateAccountStatus",
      api.listCreateAccountStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.createAccountStatuses().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.CreateAccountStatus
          .wrap(item)
      )
      .provide(r)
    def untagResource(
        request: io.github.vigoo.zioaws.organizations.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provide(r)
    def removeAccountFromOrganization(
        request: io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveAccountFromOrganizationRequest,
      RemoveAccountFromOrganizationResponse
    ]("removeAccountFromOrganization", api.removeAccountFromOrganization)(
      request.buildAwsValue()
    ).unit.provide(r)
    def listAWSServiceAccessForOrganization(
        request: io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAwsServiceAccessForOrganizationRequest,
      ListAwsServiceAccessForOrganizationResponse,
      EnabledServicePrincipal
    ](
      "listAWSServiceAccessForOrganization",
      api.listAWSServiceAccessForOrganization,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.enabledServicePrincipals().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal
          .wrap(item)
      )
      .provide(r)
    def deregisterDelegatedAdministrator(
        request: io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeregisterDelegatedAdministratorRequest,
      DeregisterDelegatedAdministratorResponse
    ]("deregisterDelegatedAdministrator", api.deregisterDelegatedAdministrator)(
      request.buildAwsValue()
    ).unit.provide(r)
    def declineHandshake(
        request: io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse.ReadOnly
    ] = asyncRequestResponse[DeclineHandshakeRequest, DeclineHandshakeResponse](
      "declineHandshake",
      api.declineHandshake
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse.wrap
      )
      .provide(r)
    def attachPolicy(
        request: io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AttachPolicyRequest, AttachPolicyResponse](
        "attachPolicy",
        api.attachPolicy
      )(request.buildAwsValue()).unit.provide(r)
    def listTagsForResource(
        request: io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse,
      Tag
    ](
      "listTagsForResource",
      api.listTagsForResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tags().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.organizations.model.Tag.wrap(item))
      .provide(r)
    def listDelegatedServicesForAccount(
        request: io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDelegatedServicesForAccountRequest,
      ListDelegatedServicesForAccountResponse,
      DelegatedService
    ](
      "listDelegatedServicesForAccount",
      api.listDelegatedServicesForAccount,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.delegatedServices().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.DelegatedService.wrap(item)
      )
      .provide(r)
    def registerDelegatedAdministrator(
        request: io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RegisterDelegatedAdministratorRequest,
      RegisterDelegatedAdministratorResponse
    ]("registerDelegatedAdministrator", api.registerDelegatedAdministrator)(
      request.buildAwsValue()
    ).unit.provide(r)
    def describeEffectivePolicy(
        request: io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEffectivePolicyRequest,
      DescribeEffectivePolicyResponse
    ]("describeEffectivePolicy", api.describeEffectivePolicy)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse.wrap
    ).provide(r)
    def createPolicy(
        request: io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse.ReadOnly
    ] = asyncRequestResponse[CreatePolicyRequest, CreatePolicyResponse](
      "createPolicy",
      api.createPolicy
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse.wrap)
      .provide(r)
    def tagResource(
        request: io.github.vigoo.zioaws.organizations.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provide(r)
    def listChildren(
        request: io.github.vigoo.zioaws.organizations.model.ListChildrenRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Child.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListChildrenRequest,
      ListChildrenResponse,
      Child
    ](
      "listChildren",
      api.listChildren,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.children().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.organizations.model.Child.wrap(item))
      .provide(r)
    def deletePolicy(
        request: io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeletePolicyRequest, DeletePolicyResponse](
        "deletePolicy",
        api.deletePolicy
      )(request.buildAwsValue()).unit.provide(r)
    def listHandshakesForAccount(
        request: io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListHandshakesForAccountRequest,
      ListHandshakesForAccountResponse,
      Handshake
    ](
      "listHandshakesForAccount",
      api.listHandshakesForAccount,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.handshakes().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.Handshake.wrap(item)
      )
      .provide(r)
    def createGovCloudAccount(
        request: io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateGovCloudAccountRequest,
      CreateGovCloudAccountResponse
    ]("createGovCloudAccount", api.createGovCloudAccount)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountResponse.wrap
    ).provide(r)
    def disableAWSServiceAccess(
        request: io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisableAwsServiceAccessRequest,
      DisableAwsServiceAccessResponse
    ]("disableAWSServiceAccess", api.disableAWSServiceAccess)(
      request.buildAwsValue()
    ).unit.provide(r)
    def listDelegatedAdministrators(
        request: io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListDelegatedAdministratorsRequest,
      ListDelegatedAdministratorsResponse,
      DelegatedAdministrator
    ](
      "listDelegatedAdministrators",
      api.listDelegatedAdministrators,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.delegatedAdministrators().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.organizations.model.DelegatedAdministrator
          .wrap(item)
      )
      .provide(r)
    def createOrganization(
        request: io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateOrganizationRequest,
      CreateOrganizationResponse
    ]("createOrganization", api.createOrganization)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse.wrap
      )
      .provide(r)
  }
  def listParents(
      request: io.github.vigoo.zioaws.organizations.model.ListParentsRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly
  ] = ZStream.accessStream(_.get.listParents(request))
  def inviteAccountToOrganization(
      request: io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationResponse.ReadOnly
  ] = ZIO.accessM(_.get.inviteAccountToOrganization(request))
  def describeOrganization(): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DescribeOrganizationResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeOrganization())
  def describePolicy(
      request: io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DescribePolicyResponse.ReadOnly
  ] = ZIO.accessM(_.get.describePolicy(request))
  def createAccount(
      request: io.github.vigoo.zioaws.organizations.model.CreateAccountRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.CreateAccountResponse.ReadOnly
  ] = ZIO.accessM(_.get.createAccount(request))
  def moveAccount(
      request: io.github.vigoo.zioaws.organizations.model.MoveAccountRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.moveAccount(request))
  def listAccounts(
      request: io.github.vigoo.zioaws.organizations.model.ListAccountsRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
  ] = ZStream.accessStream(_.get.listAccounts(request))
  def deleteOrganizationalUnit(
      request: io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.deleteOrganizationalUnit(request))
  def enableAllFeatures(
      request: io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.EnableAllFeaturesResponse.ReadOnly
  ] = ZIO.accessM(_.get.enableAllFeatures(request))
  def cancelHandshake(
      request: io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse.ReadOnly
  ] = ZIO.accessM(_.get.cancelHandshake(request))
  def listAccountsForParent(
      request: io.github.vigoo.zioaws.organizations.model.ListAccountsForParentRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
  ] = ZStream.accessStream(_.get.listAccountsForParent(request))
  def enablePolicyType(
      request: io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse.ReadOnly
  ] = ZIO.accessM(_.get.enablePolicyType(request))
  def disablePolicyType(
      request: io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse.ReadOnly
  ] = ZIO.accessM(_.get.disablePolicyType(request))
  def describeOrganizationalUnit(
      request: io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeOrganizationalUnit(request))
  def listHandshakesForOrganization(
      request: io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
  ] = ZStream.accessStream(_.get.listHandshakesForOrganization(request))
  def listTargetsForPolicy(
      request: io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly
  ] = ZStream.accessStream(_.get.listTargetsForPolicy(request))
  def detachPolicy(
      request: io.github.vigoo.zioaws.organizations.model.DetachPolicyRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.detachPolicy(request))
  def updatePolicy(
      request: io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.UpdatePolicyResponse.ReadOnly
  ] = ZIO.accessM(_.get.updatePolicy(request))
  def leaveOrganization(): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.leaveOrganization())
  def enableAWSServiceAccess(
      request: io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.enableAWSServiceAccess(request))
  def describeAccount(
      request: io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeAccount(request))
  def deleteOrganization(): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.deleteOrganization())
  def createOrganizationalUnit(
      request: io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse.ReadOnly
  ] = ZIO.accessM(_.get.createOrganizationalUnit(request))
  def acceptHandshake(
      request: io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse.ReadOnly
  ] = ZIO.accessM(_.get.acceptHandshake(request))
  def listPoliciesForTarget(
      request: io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
  ] = ZStream.accessStream(_.get.listPoliciesForTarget(request))
  def listOrganizationalUnitsForParent(
      request: io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
  ] = ZStream.accessStream(_.get.listOrganizationalUnitsForParent(request))
  def updateOrganizationalUnit(
      request: io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateOrganizationalUnit(request))
  def listPolicies(
      request: io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
  ] = ZStream.accessStream(_.get.listPolicies(request))
  def describeHandshake(
      request: io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DescribeHandshakeResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeHandshake(request))
  def describeCreateAccountStatus(
      request: io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeCreateAccountStatus(request))
  def listRoots(
      request: io.github.vigoo.zioaws.organizations.model.ListRootsRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.Root.ReadOnly
  ] = ZStream.accessStream(_.get.listRoots(request))
  def listCreateAccountStatus(
      request: io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
  ] = ZStream.accessStream(_.get.listCreateAccountStatus(request))
  def untagResource(
      request: io.github.vigoo.zioaws.organizations.model.UntagResourceRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.untagResource(request))
  def removeAccountFromOrganization(
      request: io.github.vigoo.zioaws.organizations.model.RemoveAccountFromOrganizationRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.removeAccountFromOrganization(request))
  def listAWSServiceAccessForOrganization(
      request: io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly
  ] = ZStream.accessStream(_.get.listAWSServiceAccessForOrganization(request))
  def deregisterDelegatedAdministrator(
      request: io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.deregisterDelegatedAdministrator(request))
  def declineHandshake(
      request: io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse.ReadOnly
  ] = ZIO.accessM(_.get.declineHandshake(request))
  def attachPolicy(
      request: io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.attachPolicy(request))
  def listTagsForResource(
      request: io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
  ] = ZStream.accessStream(_.get.listTagsForResource(request))
  def listDelegatedServicesForAccount(
      request: io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly
  ] = ZStream.accessStream(_.get.listDelegatedServicesForAccount(request))
  def registerDelegatedAdministrator(
      request: io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.registerDelegatedAdministrator(request))
  def describeEffectivePolicy(
      request: io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeEffectivePolicy(request))
  def createPolicy(
      request: io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse.ReadOnly
  ] = ZIO.accessM(_.get.createPolicy(request))
  def tagResource(
      request: io.github.vigoo.zioaws.organizations.model.TagResourceRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.tagResource(request))
  def listChildren(
      request: io.github.vigoo.zioaws.organizations.model.ListChildrenRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.Child.ReadOnly
  ] = ZStream.accessStream(_.get.listChildren(request))
  def deletePolicy(
      request: io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.deletePolicy(request))
  def listHandshakesForAccount(
      request: io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest
  ): ZStream[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
  ] = ZStream.accessStream(_.get.listHandshakesForAccount(request))
  def createGovCloudAccount(
      request: io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.CreateGovCloudAccountResponse.ReadOnly
  ] = ZIO.accessM(_.get.createGovCloudAccount(request))
  def disableAWSServiceAccess(
      request: io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest
  ): ZIO[Organizations, AwsError, Unit] =
    ZIO.accessM(_.get.disableAWSServiceAccess(request))
  def listDelegatedAdministrators(
      request: io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest
  ): ZStream[Organizations, AwsError, ReadOnly] =
    ZStream.accessStream(_.get.listDelegatedAdministrators(request))
  def createOrganization(
      request: io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest
  ): ZIO[
    Organizations,
    AwsError,
    io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse.ReadOnly
  ] = ZIO.accessM(_.get.createOrganization(request))
}
