package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateOrganizationalUnitResponse(
    organizationalUnit: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse = {
    import UpdateOrganizationalUnitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse
      .builder()
      .optionallyWith(organizationalUnit.map(value => value.buildAwsValue()))(
        _.organizationalUnit
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse
      .wrap(buildAwsValue())
}
object UpdateOrganizationalUnitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse =
      io.github.vigoo.zioaws.organizations.model
        .UpdateOrganizationalUnitResponse(
          organizationalUnitValue.map(value => value.editable)
        )
    def organizationalUnitValue: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ]
    def organizationalUnit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ] =
      AwsError.unwrapOptionField("organizationalUnit", organizationalUnitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse
  ) extends io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse.ReadOnly {
    override def organizationalUnitValue: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ] = scala
      .Option(impl.organizationalUnit())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.OrganizationalUnit
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse
  ): io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitResponse.ReadOnly =
    new Wrapper(impl)
}
