package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  OrganizationalUnitName,
  OrganizationalUnitId
}
import scala.jdk.CollectionConverters.*
final case class UpdateOrganizationalUnitRequest(
    organizationalUnitId: OrganizationalUnitId,
    name: Option[OrganizationalUnitName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest = {
    import UpdateOrganizationalUnitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest
      .builder()
      .organizationalUnitId(organizationalUnitId: java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest
      .wrap(buildAwsValue())
}
object UpdateOrganizationalUnitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest =
      io.github.vigoo.zioaws.organizations.model
        .UpdateOrganizationalUnitRequest(
          organizationalUnitIdValue,
          nameValue.map(value => value)
        )
    def organizationalUnitIdValue: OrganizationalUnitId
    def nameValue: Option[OrganizationalUnitName]
    def organizationalUnitId: ZIO[Any, Nothing, OrganizationalUnitId] =
      ZIO.succeed(organizationalUnitIdValue)
    def name: ZIO[Any, AwsError, OrganizationalUnitName] =
      AwsError.unwrapOptionField("name", nameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest
  ) extends io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest.ReadOnly {
    override def organizationalUnitIdValue: OrganizationalUnitId =
      impl.organizationalUnitId(): OrganizationalUnitId
    override def nameValue: Option[OrganizationalUnitName] =
      scala.Option(impl.name()).map(value => value: OrganizationalUnitName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest
  ): io.github.vigoo.zioaws.organizations.model.UpdateOrganizationalUnitRequest.ReadOnly =
    new Wrapper(impl)
}
