package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.{
  TagKey,
  TaggableResourceId
}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceId: TaggableResourceId,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.UntagResourceRequest
      .builder()
      .resourceId(resourceId: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.UntagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.UntagResourceRequest
      .wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.UntagResourceRequest =
      io.github.vigoo.zioaws.organizations.model
        .UntagResourceRequest(resourceIdValue, tagKeysValue)
    def resourceIdValue: TaggableResourceId
    def tagKeysValue: List[TagKey]
    def resourceId: ZIO[Any, Nothing, TaggableResourceId] =
      ZIO.succeed(resourceIdValue)
    def tagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.UntagResourceRequest
  ) extends io.github.vigoo.zioaws.organizations.model.UntagResourceRequest.ReadOnly {
    override def resourceIdValue: TaggableResourceId =
      impl.resourceId(): TaggableResourceId
    override def tagKeysValue: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: TagKey
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.UntagResourceRequest
  ): io.github.vigoo.zioaws.organizations.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
