package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.{
  ServicePrincipal,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class RegisterDelegatedAdministratorRequest(
    accountId: AccountId,
    servicePrincipal: ServicePrincipal
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorRequest = {
    import RegisterDelegatedAdministratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .servicePrincipal(servicePrincipal: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest
      .wrap(buildAwsValue())
}
object RegisterDelegatedAdministratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest =
      io.github.vigoo.zioaws.organizations.model
        .RegisterDelegatedAdministratorRequest(
          accountIdValue,
          servicePrincipalValue
        )
    def accountIdValue: AccountId
    def servicePrincipalValue: ServicePrincipal
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def servicePrincipal: ZIO[Any, Nothing, ServicePrincipal] =
      ZIO.succeed(servicePrincipalValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorRequest
  ) extends io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def servicePrincipalValue: ServicePrincipal =
      impl.servicePrincipal(): ServicePrincipal
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorRequest
  ): io.github.vigoo.zioaws.organizations.model.RegisterDelegatedAdministratorRequest.ReadOnly =
    new Wrapper(impl)
}
