package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
sealed trait OrganizationFeatureSet {
  def unwrap: software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet
}
object OrganizationFeatureSet {
  def wrap(
      value: software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet
  ): io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet =
    value match {
      case software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.ALL =>
        val r = ALL
        r
      case software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.CONSOLIDATED_BILLING =>
        val r = CONSOLIDATED_BILLING
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet =
      software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL
      extends io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet =
      software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.ALL
  }
  case object CONSOLIDATED_BILLING
      extends io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet =
      software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet.CONSOLIDATED_BILLING
  }
}
