package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken,
  ParentId
}
import scala.jdk.CollectionConverters.*
final case class ListOrganizationalUnitsForParentRequest(
    parentId: ParentId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest = {
    import ListOrganizationalUnitsForParentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest
      .builder()
      .parentId(parentId: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest
      .wrap(buildAwsValue())
}
object ListOrganizationalUnitsForParentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest =
      io.github.vigoo.zioaws.organizations.model
        .ListOrganizationalUnitsForParentRequest(
          parentIdValue,
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value)
        )
    def parentIdValue: ParentId
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def parentId: ZIO[Any, Nothing, ParentId] = ZIO.succeed(parentIdValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest.ReadOnly {
    override def parentIdValue: ParentId = impl.parentId(): ParentId
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest
  ): io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentRequest.ReadOnly =
    new Wrapper(impl)
}
