package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken
}
import scala.jdk.CollectionConverters.*
final case class ListHandshakesForAccountRequest(
    filter: Option[io.github.vigoo.zioaws.organizations.model.HandshakeFilter] =
      None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest = {
    import ListHandshakesForAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest
      .wrap(buildAwsValue())
}
object ListHandshakesForAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest =
      io.github.vigoo.zioaws.organizations.model
        .ListHandshakesForAccountRequest(
          filterValue.map(value => value.editable),
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value)
        )
    def filterValue: Option[
      io.github.vigoo.zioaws.organizations.model.HandshakeFilter.ReadOnly
    ]
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.HandshakeFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest.ReadOnly {
    override def filterValue: Option[
      io.github.vigoo.zioaws.organizations.model.HandshakeFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.HandshakeFilter.wrap(value)
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest
  ): io.github.vigoo.zioaws.organizations.model.ListHandshakesForAccountRequest.ReadOnly =
    new Wrapper(impl)
}
