package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class ListDelegatedServicesForAccountRequest(
    accountId: AccountId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest = {
    import ListDelegatedServicesForAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest
      .wrap(buildAwsValue())
}
object ListDelegatedServicesForAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest =
      io.github.vigoo.zioaws.organizations.model
        .ListDelegatedServicesForAccountRequest(
          accountIdValue,
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value)
        )
    def accountIdValue: AccountId
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest
  ): io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountRequest.ReadOnly =
    new Wrapper(impl)
}
