package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListDelegatedAdministratorsResponse(
    delegatedAdministrators: Option[Iterable[
      io.github.vigoo.zioaws.organizations.model.DelegatedAdministrator
    ]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse = {
    import ListDelegatedAdministratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse
      .builder()
      .optionallyWith(
        delegatedAdministrators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.delegatedAdministrators)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsResponse
      .wrap(buildAwsValue())
}
object ListDelegatedAdministratorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsResponse =
      io.github.vigoo.zioaws.organizations.model
        .ListDelegatedAdministratorsResponse(
          delegatedAdministratorsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def delegatedAdministratorsValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.DelegatedAdministrator.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def delegatedAdministrators: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.DelegatedAdministrator.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "delegatedAdministrators",
      delegatedAdministratorsValue
    )
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsResponse.ReadOnly {
    override def delegatedAdministratorsValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.DelegatedAdministrator.ReadOnly
    ]] = scala
      .Option(impl.delegatedAdministrators())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.DelegatedAdministrator
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse
  ): io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsResponse.ReadOnly =
    new Wrapper(impl)
}
