package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListCreateAccountStatusResponse(
    createAccountStatuses: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.CreateAccountStatus]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse = {
    import ListCreateAccountStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse
      .builder()
      .optionallyWith(
        createAccountStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createAccountStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusResponse
      .wrap(buildAwsValue())
}
object ListCreateAccountStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusResponse =
      io.github.vigoo.zioaws.organizations.model
        .ListCreateAccountStatusResponse(
          createAccountStatusesValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def createAccountStatusesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def createAccountStatuses: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "createAccountStatuses",
      createAccountStatusesValue
    )
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusResponse.ReadOnly {
    override def createAccountStatusesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
    ]] = scala
      .Option(impl.createAccountStatuses())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.CreateAccountStatus
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse
  ): io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusResponse.ReadOnly =
    new Wrapper(impl)
}
