package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  Timestamp,
  ServicePrincipal
}
import scala.jdk.CollectionConverters.*
final case class EnabledServicePrincipal(
    servicePrincipal: Option[ServicePrincipal] = None,
    dateEnabled: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal = {
    import EnabledServicePrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal
      .builder()
      .optionallyWith(servicePrincipal.map(value => value: java.lang.String))(
        _.servicePrincipal
      )
      .optionallyWith(dateEnabled.map(value => value: Instant))(_.dateEnabled)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal
      .wrap(buildAwsValue())
}
object EnabledServicePrincipal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal =
      io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal(
        servicePrincipalValue.map(value => value),
        dateEnabledValue.map(value => value)
      )
    def servicePrincipalValue: Option[ServicePrincipal]
    def dateEnabledValue: Option[Timestamp]
    def servicePrincipal: ZIO[Any, AwsError, ServicePrincipal] =
      AwsError.unwrapOptionField("servicePrincipal", servicePrincipalValue)
    def dateEnabled: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dateEnabled", dateEnabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal
  ) extends io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly {
    override def servicePrincipalValue: Option[ServicePrincipal] = scala
      .Option(impl.servicePrincipal())
      .map(value => value: ServicePrincipal)
    override def dateEnabledValue: Option[Timestamp] =
      scala.Option(impl.dateEnabled()).map(value => value: Timestamp)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal
  ): io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly =
    new Wrapper(impl)
}
