package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EnablePolicyTypeResponse(
    root: Option[io.github.vigoo.zioaws.organizations.model.Root] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse = {
    import EnablePolicyTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse
      .builder()
      .optionallyWith(root.map(value => value.buildAwsValue()))(_.root)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse
      .wrap(buildAwsValue())
}
object EnablePolicyTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse =
      io.github.vigoo.zioaws.organizations.model
        .EnablePolicyTypeResponse(rootValue.map(value => value.editable))
    def rootValue
        : Option[io.github.vigoo.zioaws.organizations.model.Root.ReadOnly]
    def root: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Root.ReadOnly
    ] = AwsError.unwrapOptionField("root", rootValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse
  ) extends io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse.ReadOnly {
    override def rootValue
        : Option[io.github.vigoo.zioaws.organizations.model.Root.ReadOnly] =
      scala
        .Option(impl.root())
        .map(value =>
          io.github.vigoo.zioaws.organizations.model.Root.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse
  ): io.github.vigoo.zioaws.organizations.model.EnablePolicyTypeResponse.ReadOnly =
    new Wrapper(impl)
}
