package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  PolicyTargetId,
  Timestamp,
  PolicyContent
}
import scala.jdk.CollectionConverters.*
final case class EffectivePolicy(
    policyContent: Option[PolicyContent] = None,
    lastUpdatedTimestamp: Option[Timestamp] = None,
    targetId: Option[PolicyTargetId] = None,
    policyType: Option[
      io.github.vigoo.zioaws.organizations.model.EffectivePolicyType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.EffectivePolicy = {
    import EffectivePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.EffectivePolicy
      .builder()
      .optionallyWith(policyContent.map(value => value: java.lang.String))(
        _.policyContent
      )
      .optionallyWith(lastUpdatedTimestamp.map(value => value: Instant))(
        _.lastUpdatedTimestamp
      )
      .optionallyWith(targetId.map(value => value: java.lang.String))(
        _.targetId
      )
      .optionallyWith(policyType.map(value => value.unwrap))(_.policyType)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.EffectivePolicy.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.EffectivePolicy
      .wrap(buildAwsValue())
}
object EffectivePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.EffectivePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.EffectivePolicy =
      io.github.vigoo.zioaws.organizations.model.EffectivePolicy(
        policyContentValue.map(value => value),
        lastUpdatedTimestampValue.map(value => value),
        targetIdValue.map(value => value),
        policyTypeValue.map(value => value)
      )
    def policyContentValue: Option[PolicyContent]
    def lastUpdatedTimestampValue: Option[Timestamp]
    def targetIdValue: Option[PolicyTargetId]
    def policyTypeValue
        : Option[io.github.vigoo.zioaws.organizations.model.EffectivePolicyType]
    def policyContent: ZIO[Any, AwsError, PolicyContent] =
      AwsError.unwrapOptionField("policyContent", policyContentValue)
    def lastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestampValue)
    def targetId: ZIO[Any, AwsError, PolicyTargetId] =
      AwsError.unwrapOptionField("targetId", targetIdValue)
    def policyType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.EffectivePolicyType
    ] = AwsError.unwrapOptionField("policyType", policyTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.EffectivePolicy
  ) extends io.github.vigoo.zioaws.organizations.model.EffectivePolicy.ReadOnly {
    override def policyContentValue: Option[PolicyContent] =
      scala.Option(impl.policyContent()).map(value => value: PolicyContent)
    override def lastUpdatedTimestampValue: Option[Timestamp] =
      scala.Option(impl.lastUpdatedTimestamp()).map(value => value: Timestamp)
    override def targetIdValue: Option[PolicyTargetId] =
      scala.Option(impl.targetId()).map(value => value: PolicyTargetId)
    override def policyTypeValue: Option[
      io.github.vigoo.zioaws.organizations.model.EffectivePolicyType
    ] = scala
      .Option(impl.policyType())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.EffectivePolicyType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.EffectivePolicy
  ): io.github.vigoo.zioaws.organizations.model.EffectivePolicy.ReadOnly =
    new Wrapper(impl)
}
