package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.PolicyTargetId
import scala.jdk.CollectionConverters.*
final case class DescribeEffectivePolicyRequest(
    policyType: io.github.vigoo.zioaws.organizations.model.EffectivePolicyType,
    targetId: Option[PolicyTargetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest = {
    import DescribeEffectivePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest
      .builder()
      .policyType(policyType.unwrap)
      .optionallyWith(targetId.map(value => value: java.lang.String))(
        _.targetId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest
      .wrap(buildAwsValue())
}
object DescribeEffectivePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest =
      io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest(
        policyTypeValue,
        targetIdValue.map(value => value)
      )
    def policyTypeValue
        : io.github.vigoo.zioaws.organizations.model.EffectivePolicyType
    def targetIdValue: Option[PolicyTargetId]
    def policyType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.organizations.model.EffectivePolicyType
    ] = ZIO.succeed(policyTypeValue)
    def targetId: ZIO[Any, AwsError, PolicyTargetId] =
      AwsError.unwrapOptionField("targetId", targetIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest.ReadOnly {
    override def policyTypeValue
        : io.github.vigoo.zioaws.organizations.model.EffectivePolicyType =
      io.github.vigoo.zioaws.organizations.model.EffectivePolicyType
        .wrap(impl.policyType())
    override def targetIdValue: Option[PolicyTargetId] =
      scala.Option(impl.targetId()).map(value => value: PolicyTargetId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest
  ): io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
