package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  OrganizationalUnitName,
  ParentId
}
import scala.jdk.CollectionConverters.*
final case class CreateOrganizationalUnitRequest(
    parentId: ParentId,
    name: OrganizationalUnitName,
    tags: Option[Iterable[io.github.vigoo.zioaws.organizations.model.Tag]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest = {
    import CreateOrganizationalUnitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest
      .builder()
      .parentId(parentId: java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest
      .wrap(buildAwsValue())
}
object CreateOrganizationalUnitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest =
      io.github.vigoo.zioaws.organizations.model
        .CreateOrganizationalUnitRequest(
          parentIdValue,
          nameValue,
          tagsValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def parentIdValue: ParentId
    def nameValue: OrganizationalUnitName
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]]
    def parentId: ZIO[Any, Nothing, ParentId] = ZIO.succeed(parentIdValue)
    def name: ZIO[Any, Nothing, OrganizationalUnitName] = ZIO.succeed(nameValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest
  ) extends io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest.ReadOnly {
    override def parentIdValue: ParentId = impl.parentId(): ParentId
    override def nameValue: OrganizationalUnitName =
      impl.name(): OrganizationalUnitName
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest
  ): io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitRequest.ReadOnly =
    new Wrapper(impl)
}
