package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  AccountId,
  Timestamp,
  AccountName,
  CreateAccountRequestId
}
import scala.jdk.CollectionConverters.*
final case class CreateAccountStatus(
    id: Option[CreateAccountRequestId] = None,
    accountName: Option[AccountName] = None,
    state: Option[
      io.github.vigoo.zioaws.organizations.model.CreateAccountState
    ] = None,
    requestedTimestamp: Option[Timestamp] = None,
    completedTimestamp: Option[Timestamp] = None,
    accountId: Option[AccountId] = None,
    govCloudAccountId: Option[AccountId] = None,
    failureReason: Option[
      io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CreateAccountStatus = {
    import CreateAccountStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateAccountStatus
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(accountName.map(value => value: java.lang.String))(
        _.accountName
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(requestedTimestamp.map(value => value: Instant))(
        _.requestedTimestamp
      )
      .optionallyWith(completedTimestamp.map(value => value: Instant))(
        _.completedTimestamp
      )
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(govCloudAccountId.map(value => value: java.lang.String))(
        _.govCloudAccountId
      )
      .optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CreateAccountStatus
      .wrap(buildAwsValue())
}
object CreateAccountStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CreateAccountStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CreateAccountStatus =
      io.github.vigoo.zioaws.organizations.model.CreateAccountStatus(
        idValue.map(value => value),
        accountNameValue.map(value => value),
        stateValue.map(value => value),
        requestedTimestampValue.map(value => value),
        completedTimestampValue.map(value => value),
        accountIdValue.map(value => value),
        govCloudAccountIdValue.map(value => value),
        failureReasonValue.map(value => value)
      )
    def idValue: Option[CreateAccountRequestId]
    def accountNameValue: Option[AccountName]
    def stateValue
        : Option[io.github.vigoo.zioaws.organizations.model.CreateAccountState]
    def requestedTimestampValue: Option[Timestamp]
    def completedTimestampValue: Option[Timestamp]
    def accountIdValue: Option[AccountId]
    def govCloudAccountIdValue: Option[AccountId]
    def failureReasonValue: Option[
      io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason
    ]
    def id: ZIO[Any, AwsError, CreateAccountRequestId] =
      AwsError.unwrapOptionField("id", idValue)
    def accountName: ZIO[Any, AwsError, AccountName] =
      AwsError.unwrapOptionField("accountName", accountNameValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CreateAccountState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def requestedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("requestedTimestamp", requestedTimestampValue)
    def completedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completedTimestamp", completedTimestampValue)
    def accountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
    def govCloudAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("govCloudAccountId", govCloudAccountIdValue)
    def failureReason: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason
    ] = AwsError.unwrapOptionField("failureReason", failureReasonValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CreateAccountStatus
  ) extends io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly {
    override def idValue: Option[CreateAccountRequestId] =
      scala.Option(impl.id()).map(value => value: CreateAccountRequestId)
    override def accountNameValue: Option[AccountName] =
      scala.Option(impl.accountName()).map(value => value: AccountName)
    override def stateValue: Option[
      io.github.vigoo.zioaws.organizations.model.CreateAccountState
    ] = scala
      .Option(impl.state())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.CreateAccountState
          .wrap(value)
      )
    override def requestedTimestampValue: Option[Timestamp] =
      scala.Option(impl.requestedTimestamp()).map(value => value: Timestamp)
    override def completedTimestampValue: Option[Timestamp] =
      scala.Option(impl.completedTimestamp()).map(value => value: Timestamp)
    override def accountIdValue: Option[AccountId] =
      scala.Option(impl.accountId()).map(value => value: AccountId)
    override def govCloudAccountIdValue: Option[AccountId] =
      scala.Option(impl.govCloudAccountId()).map(value => value: AccountId)
    override def failureReasonValue: Option[
      io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason
    ] = scala
      .Option(impl.failureReason())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CreateAccountStatus
  ): io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly =
    new Wrapper(impl)
}
