package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.{
  PolicyTargetId,
  PolicyId
}
import scala.jdk.CollectionConverters.*
final case class AttachPolicyRequest(
    policyId: PolicyId,
    targetId: PolicyTargetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.AttachPolicyRequest = {
    import AttachPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.AttachPolicyRequest
      .builder()
      .policyId(policyId: java.lang.String)
      .targetId(targetId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest
      .wrap(buildAwsValue())
}
object AttachPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.AttachPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest =
      io.github.vigoo.zioaws.organizations.model
        .AttachPolicyRequest(policyIdValue, targetIdValue)
    def policyIdValue: PolicyId
    def targetIdValue: PolicyTargetId
    def policyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyIdValue)
    def targetId: ZIO[Any, Nothing, PolicyTargetId] = ZIO.succeed(targetIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.AttachPolicyRequest
  ) extends io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest.ReadOnly {
    override def policyIdValue: PolicyId = impl.policyId(): PolicyId
    override def targetIdValue: PolicyTargetId = impl.targetId(): PolicyTargetId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.AttachPolicyRequest
  ): io.github.vigoo.zioaws.organizations.model.AttachPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
