package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.TaggableResourceId
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceId: TaggableResourceId,
    tags: Iterable[io.github.vigoo.zioaws.organizations.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.TagResourceRequest
      .builder()
      .resourceId(resourceId: java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.TagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.TagResourceRequest
      .wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.TagResourceRequest =
      io.github.vigoo.zioaws.organizations.model.TagResourceRequest(
        resourceIdValue,
        tagsValue.map { item =>
          item.editable
        }
      )
    def resourceIdValue: TaggableResourceId
    def tagsValue: List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]
    def resourceId: ZIO[Any, Nothing, TaggableResourceId] =
      ZIO.succeed(resourceIdValue)
    def tags: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
    ]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.TagResourceRequest
  ) extends io.github.vigoo.zioaws.organizations.model.TagResourceRequest.ReadOnly {
    override def resourceIdValue: TaggableResourceId =
      impl.resourceId(): TaggableResourceId
    override def tagsValue
        : List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.organizations.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.TagResourceRequest
  ): io.github.vigoo.zioaws.organizations.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
