package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PolicyTypeSummary(
    `type`: Option[io.github.vigoo.zioaws.organizations.model.PolicyType] =
      None,
    status: Option[
      io.github.vigoo.zioaws.organizations.model.PolicyTypeStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.PolicyTypeSummary = {
    import PolicyTypeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.PolicyTypeSummary
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary
      .wrap(buildAwsValue())
}
object PolicyTypeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.PolicyTypeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary =
      io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary(
        typeValue.map(value => value),
        statusValue.map(value => value)
      )
    def typeValue: Option[io.github.vigoo.zioaws.organizations.model.PolicyType]
    def statusValue
        : Option[io.github.vigoo.zioaws.organizations.model.PolicyTypeStatus]
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.PolicyType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.PolicyTypeStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.PolicyTypeSummary
  ) extends io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary.ReadOnly {
    override def typeValue
        : Option[io.github.vigoo.zioaws.organizations.model.PolicyType] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.PolicyType.wrap(value)
      )
    override def statusValue
        : Option[io.github.vigoo.zioaws.organizations.model.PolicyTypeStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.organizations.model.PolicyTypeStatus
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.PolicyTypeSummary
  ): io.github.vigoo.zioaws.organizations.model.PolicyTypeSummary.ReadOnly =
    new Wrapper(impl)
}
