package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.PolicyContent
import scala.jdk.CollectionConverters.*
final case class Policy(
    policySummary: Option[
      io.github.vigoo.zioaws.organizations.model.PolicySummary
    ] = None,
    content: Option[PolicyContent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.Policy = {
    import Policy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Policy
      .builder()
      .optionallyWith(policySummary.map(value => value.buildAwsValue()))(
        _.policySummary
      )
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.organizations.model.Policy.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.Policy.wrap(buildAwsValue())
}
object Policy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.Policy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.Policy =
      io.github.vigoo.zioaws.organizations.model.Policy(
        policySummaryValue.map(value => value.editable),
        contentValue.map(value => value)
      )
    def policySummaryValue: Option[
      io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
    ]
    def contentValue: Option[PolicyContent]
    def policySummary: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
    ] = AwsError.unwrapOptionField("policySummary", policySummaryValue)
    def content: ZIO[Any, AwsError, PolicyContent] =
      AwsError.unwrapOptionField("content", contentValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.Policy
  ) extends io.github.vigoo.zioaws.organizations.model.Policy.ReadOnly {
    override def policySummaryValue: Option[
      io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
    ] = scala
      .Option(impl.policySummary())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.PolicySummary.wrap(value)
      )
    override def contentValue: Option[PolicyContent] =
      scala.Option(impl.content()).map(value => value: PolicyContent)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.Policy
  ): io.github.vigoo.zioaws.organizations.model.Policy.ReadOnly = new Wrapper(
    impl
  )
}
