package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.ParentId
import scala.jdk.CollectionConverters.*
final case class Parent(
    id: Option[ParentId] = None,
    `type`: Option[io.github.vigoo.zioaws.organizations.model.ParentType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.Parent = {
    import Parent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Parent
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.Parent.wrap(buildAwsValue())
}
object Parent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.Parent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.Parent =
      io.github.vigoo.zioaws.organizations.model
        .Parent(idValue.map(value => value), typeValue.map(value => value))
    def idValue: Option[ParentId]
    def typeValue: Option[io.github.vigoo.zioaws.organizations.model.ParentType]
    def id: ZIO[Any, AwsError, ParentId] =
      AwsError.unwrapOptionField("id", idValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.ParentType
    ] = AwsError.unwrapOptionField("type", typeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.Parent
  ) extends io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly {
    override def idValue: Option[ParentId] =
      scala.Option(impl.id()).map(value => value: ParentId)
    override def typeValue
        : Option[io.github.vigoo.zioaws.organizations.model.ParentType] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.ParentType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.Parent
  ): io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly = new Wrapper(
    impl
  )
}
