package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  OrganizationalUnitName,
  OrganizationalUnitArn,
  OrganizationalUnitId
}
import scala.jdk.CollectionConverters.*
final case class OrganizationalUnit(
    id: Option[OrganizationalUnitId] = None,
    arn: Option[OrganizationalUnitArn] = None,
    name: Option[OrganizationalUnitName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.OrganizationalUnit = {
    import OrganizationalUnit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.OrganizationalUnit
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.OrganizationalUnit
      .wrap(buildAwsValue())
}
object OrganizationalUnit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.OrganizationalUnit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.OrganizationalUnit =
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit(
        idValue.map(value => value),
        arnValue.map(value => value),
        nameValue.map(value => value)
      )
    def idValue: Option[OrganizationalUnitId]
    def arnValue: Option[OrganizationalUnitArn]
    def nameValue: Option[OrganizationalUnitName]
    def id: ZIO[Any, AwsError, OrganizationalUnitId] =
      AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, AwsError, OrganizationalUnitArn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, AwsError, OrganizationalUnitName] =
      AwsError.unwrapOptionField("name", nameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.OrganizationalUnit
  ) extends io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly {
    override def idValue: Option[OrganizationalUnitId] =
      scala.Option(impl.id()).map(value => value: OrganizationalUnitId)
    override def arnValue: Option[OrganizationalUnitArn] =
      scala.Option(impl.arn()).map(value => value: OrganizationalUnitArn)
    override def nameValue: Option[OrganizationalUnitName] =
      scala.Option(impl.name()).map(value => value: OrganizationalUnitName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.OrganizationalUnit
  ): io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly =
    new Wrapper(impl)
}
