package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken,
  PolicyId
}
import scala.jdk.CollectionConverters.*
final case class ListTargetsForPolicyRequest(
    policyId: PolicyId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest = {
    import ListTargetsForPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest
      .builder()
      .policyId(policyId: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest
      .wrap(buildAwsValue())
}
object ListTargetsForPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest =
      io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest(
        policyIdValue,
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def policyIdValue: PolicyId
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def policyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyIdValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest.ReadOnly {
    override def policyIdValue: PolicyId = impl.policyId(): PolicyId
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest
  ): io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
